/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.security.atomic.AtomicBase;
import inc.yukawa.chain.security.atomic.AtomicSecurity;
import inc.yukawa.chain.security.atomic.ErrorAtomic;
import inc.yukawa.chain.security.error.AtomicError;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.Map;

public abstract class MapperAtomicBase
extends AtomicBase {
    private AtomicSecurity defaultAtomic = new ErrorAtomic();
    private Map<Object, AtomicSecurity> atomicMap;

    protected MapperAtomicBase() {
    }

    protected MapperAtomicBase(Map<Object, AtomicSecurity> atomicMap) {
        this.atomicMap = atomicMap;
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        Object key = this.extractKey(paras, principal);
        AtomicSecurity atomic = null;
        if (key != null) {
            atomic = this.findAtomic(key, principal);
        }
        if (atomic == null) {
            atomic = this.getDefaultAtomic();
        }
        atomic.check(paras, principal);
        return paras;
    }

    protected AtomicSecurity findAtomic(Object key, ChainPrincipal principal) throws AtomicError {
        return this.getAtomicMap().get(key);
    }

    protected abstract Object extractKey(Object[] var1, ChainPrincipal var2) throws AuthorizationError;

    public Map<Object, AtomicSecurity> getAtomicMap() {
        return this.atomicMap;
    }

    public void setAtomicMap(Map<Object, AtomicSecurity> atomicMap) {
        this.atomicMap = atomicMap;
    }

    public AtomicSecurity getDefaultAtomic() {
        return this.defaultAtomic;
    }

    public void setDefaultAtomic(AtomicSecurity defaultAtomic) {
        this.defaultAtomic = defaultAtomic;
    }
}

