/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.security.atomic.RolesAtomic;
import inc.yukawa.chain.security.principal.ChainPrincipal;

public class OptionalOrgIdPrefix
extends RolesAtomic {
    private String separator = "-";
    private int paraIndex = 0;

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        String key;
        Object[] result = super.checkCall(callName, paras, principal);
        if (paras == null) {
            return result;
        }
        if (paras.length > 0 && result[this.paraIndex] instanceof String && (key = (String)result[this.paraIndex]) != null) {
            if (key.contains(this.separator)) {
                String callerOrg = principal.getOrgId();
                String prefix = callerOrg + this.separator;
                if (key.startsWith(prefix)) {
                    return result;
                }
            } else {
                return result;
            }
        }
        throw this.createError(principal, "invalid paras");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        if (this.getRoles() != null) {
            sb.append(", roles=").append(this.getRoles());
        }
        sb.append(", paraIndex=").append(this.paraIndex);
        if (this.separator != null) {
            sb.append(", separator='").append(this.separator).append('\'');
        }
        sb.append('}');
        return sb.toString().replaceFirst("\\{, ", "{");
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public int getParaIndex() {
        return this.paraIndex;
    }

    public void setParaIndex(int paraIndex) {
        this.paraIndex = paraIndex;
    }
}

