/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.security.atomic.RolesAtomic;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgPrefixLimit
extends RolesAtomic {
    private static final Logger log = LoggerFactory.getLogger(OrgPrefixLimit.class);
    private int paraIndex = 0;
    private String separator = "-";
    private boolean forcePrepend = false;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        if (this.getRoles() != null) {
            sb.append(", roles=").append(this.getRoles());
        }
        sb.append(", paraIndex=").append(this.paraIndex);
        if (this.separator != null) {
            sb.append(", separator='").append(this.separator).append('\'');
        }
        sb.append(", forcePrepend=").append(this.forcePrepend);
        sb.append('}');
        return sb.toString().replaceFirst("\\{, ", "{");
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        String key;
        Object[] result = super.checkCall(callName, paras, principal);
        if (paras == null) {
            return result;
        }
        if (paras.length > 0 && result[this.paraIndex] instanceof String && (key = (String)result[this.paraIndex]) != null) {
            result[this.paraIndex] = this.prefixOrg(key, principal);
            log.debug("checkCall: key = {}", result[this.paraIndex]);
            return result;
        }
        throw this.createError(principal, "invalid paras");
    }

    private String prefixOrg(String key, ChainPrincipal principal) {
        String prefix = principal.getOrgId() + this.separator;
        if (!this.forcePrepend && key.startsWith(prefix)) {
            return key;
        }
        return prefix + key;
    }

    public int getParaIndex() {
        return this.paraIndex;
    }

    public void setParaIndex(int paraIndex) {
        this.paraIndex = paraIndex;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isForcePrepend() {
        return this.forcePrepend;
    }

    public void setForcePrepend(boolean forcePrepend) {
        this.forcePrepend = forcePrepend;
    }
}

