/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.security.atomic.PrincipalAtomic;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLimit
extends PrincipalAtomic {
    private static final Logger log = LoggerFactory.getLogger(PropertyLimit.class);
    protected static final String VAL_CALLER_ID = "%CALLER_ID%";
    protected static final String VAL_CALLER_LANG = "%CALLER_LANG%";
    protected static final String VAL_CALLER_ORG = "%CALLER_ORG%";
    protected static final String VAL_CALLER_ORGS = "%CALLER_ORGS%";
    protected static final String VAL_SYS_MILLIS = "%SYS_MILLIS%";
    protected static final String VAL_USER_ID = "%USER_ID%";
    private String prefix = "";
    private String suffix = "";
    private String property = "userId";
    private String value = "%CALLER_ID%";
    private int paraIndex = 0;
    private boolean checkOldValue = true;
    private boolean optional = false;

    @Override
    public String toString() {
        return "PropertyLimit{" + this.property + "}";
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        Object[] result = super.checkCall(callName, paras, principal);
        if (paras == null) {
            return result;
        }
        Object para = paras[this.paraIndex];
        try {
            Object value = this.getLimitValue(paras, principal);
            String oldValue = BeanUtils.getProperty((Object)para, (String)this.property);
            if (this.checkOldValue && oldValue != null && !oldValue.equals(value)) {
                throw this.createError(principal, this.property + "=" + oldValue);
            }
            if (!this.optional || oldValue == null) {
                BeanUtils.setProperty((Object)para, (String)this.property, (Object)(this.prefix + value + this.suffix));
            }
            return paras;
        }
        catch (Exception beanEx) {
            log.warn(beanEx.getClass().getSimpleName() + " : " + beanEx, (Throwable)beanEx);
            throw this.createError(principal, beanEx.getMessage());
        }
    }

    protected Object getLimitValue(Object[] paras, ChainPrincipal principal) {
        if (VAL_CALLER_ID.equals(this.value)) {
            return principal.getUserId();
        }
        if (VAL_CALLER_ORG.equals(this.value)) {
            return principal.getOrgId();
        }
        if (VAL_CALLER_ORGS.equals(this.value)) {
            return principal.getOrgIds();
        }
        if (VAL_SYS_MILLIS.equals(this.value)) {
            return "" + System.currentTimeMillis();
        }
        if (VAL_CALLER_LANG.equals(this.value)) {
            throw new UnsupportedOperationException("principal.getLimitValue %CALLER_LANG%");
        }
        if (VAL_USER_ID.equals(this.value)) {
            return principal.getDetail("userId");
        }
        return this.value;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public int getParaIndex() {
        return this.paraIndex;
    }

    public void setParaIndex(int paraIndex) {
        this.paraIndex = paraIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isCheckOldValue() {
        return this.checkOldValue;
    }

    public void setCheckOldValue(boolean checkOldValue) {
        this.checkOldValue = checkOldValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }
}

