/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.base.core.filter.ResourceFilter;
import inc.yukawa.chain.security.atomic.AtomicSecurity;
import inc.yukawa.chain.security.atomic.ResourcePathAtomicBase;
import inc.yukawa.chain.security.error.AtomicError;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.List;

public class ResourceLimitCheck
extends ResourcePathAtomicBase {
    protected AtomicSecurity limit;

    @Override
    protected void checkPath(String callName, String path, ChainPrincipal principal) throws AuthorizationError {
        ResourceFilter limitFilter = new ResourceFilter();
        this.limit.checkCall(callName, new Object[]{limitFilter}, principal);
        if (limitFilter.getFolderNames() != null) {
            this.checkFolderNames(path, limitFilter.getFolderNames(), principal);
        }
    }

    protected void checkFolderNames(String path, List<String> folderNames, ChainPrincipal principal) throws AtomicError {
        for (String folderName : folderNames) {
            if (!path.startsWith(folderName)) continue;
            return;
        }
        this.raiseError(principal, path);
    }

    public AtomicSecurity getLimit() {
        return this.limit;
    }

    public void setLimit(AtomicSecurity limit) {
        this.limit = limit;
    }
}

