/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.atomic;

import inc.yukawa.chain.base.core.error.AuthorizationError;
import inc.yukawa.chain.security.atomic.AtomicBase;
import inc.yukawa.chain.security.atomic.AtomicSecurity;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleMapAtomic
extends AtomicBase {
    private static final Logger log = LoggerFactory.getLogger(RoleMapAtomic.class);
    private List<String> myAtomicRoles;
    private Map<String, AtomicSecurity> myRoleMap;
    private AtomicSecurity defaultAtomic;

    public RoleMapAtomic() {
        this.setAtomicRoles(new ArrayList<String>());
    }

    protected Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal, Iterable<String> roles, AtomicSecurity defaultAtomic) {
        if (principal != null && roles != null) {
            for (String role : roles) {
                if (!principal.inRole(role)) continue;
                AtomicSecurity sec = this.getRoleMap().get(role);
                log.debug("checkCall[{}] {} {}", new Object[]{role, principal, sec});
                if (sec == null) continue;
                return sec.checkCall(callName, paras, principal);
            }
        }
        log.trace("No Role matched using default {} for {}", (Object)defaultAtomic, (Object)principal);
        if (defaultAtomic != null) {
            return defaultAtomic.checkCall(callName, paras, principal);
        }
        return paras;
    }

    @Override
    public Object[] checkCall(String callName, Object[] paras, ChainPrincipal principal) {
        return this.checkCall(callName, paras, principal, this.getAtomicRoles() != null ? this.getAtomicRoles() : this.getRoleMap().keySet(), this.getDefaultAtomic());
    }

    public void check_OLD(Object[] paras, ChainPrincipal principal) throws AuthorizationError {
        if (this.myAtomicRoles != null && !this.myAtomicRoles.isEmpty()) {
            for (String role : this.getAtomicRoles()) {
                AtomicSecurity sec = this.getRoleMap().get(role);
                if (sec == null) continue;
                sec.check(paras, principal);
                log.debug("Checking {} {} {}", new Object[]{principal, role, sec});
                return;
            }
        } else if (principal != null) {
            for (Map.Entry<String, AtomicSecurity> entry : this.getRoleMap().entrySet()) {
                if (!principal.inRole(entry.getKey())) continue;
                log.debug("Checking " + entry.getValue());
                entry.getValue().check(paras, principal);
            }
        } else if (this.defaultAtomic != null) {
            this.defaultAtomic.check(paras, principal);
        }
    }

    public List<String> getAtomicRoles() {
        return this.myAtomicRoles;
    }

    public void setAtomicRoles(List<String> value) {
        this.myAtomicRoles = value;
    }

    public Map<String, AtomicSecurity> getRoleMap() {
        return this.myRoleMap;
    }

    public void setRoleMap(Map<String, AtomicSecurity> value) {
        this.myRoleMap = value;
    }

    public AtomicSecurity getDefaultAtomic() {
        return this.defaultAtomic;
    }

    public void setDefaultAtomic(AtomicSecurity defaultAtomic) {
        this.defaultAtomic = defaultAtomic;
    }

    @Override
    public String toString() {
        return "RoleMapAtomic{roles=" + (this.getAtomicRoles() != null ? this.getAtomicRoles() : this.getRoleMap().keySet()) + ", map=" + this.myRoleMap.size() + ", default=" + this.defaultAtomic + "}";
    }
}

