/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import java.util.HashMap;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class KafkaAdminConfig {
    @Bean(value={"security.AccountTopic"})
    public NewTopic accountTopic(@Value(value="${chain.security.account.topic}") String topicName, @Value(value="${chain.security.topic.partitions:2}") int partitions, @Value(value="${chain.security.topic.replication:1}") short replication) {
        return this.initCompactTopic(new NewTopic(topicName, partitions, replication));
    }

    @Bean(value={"security.AccessEventTopic"})
    @Profile(value={"beta"})
    public NewTopic accessEventTopic(@Value(value="${chain.security.access.event.topic:${app.prefix}security-access-event}") String topicName, @Value(value="${chain.security.topic.partitions:2}") int partitions, @Value(value="${chain.security.topic.replication:1}") short replication) {
        return this.initTopic(new NewTopic(topicName, partitions, replication));
    }

    @Bean(value={"auth.RevocationTopic"})
    public NewTopic revocationTopic(@Value(value="${chain.security.revocation.topic}") String topicName, @Value(value="${chain.security.topic.partitions:2}") int partitions, @Value(value="${chain.security.topic.replication:1}") short replication) {
        return this.initCompactTopic(new NewTopic(topicName, partitions, replication));
    }

    @Bean(value={"main.RoleInfoTopic"})
    @Profile(value={"init", "init-roles"})
    public NewTopic rolesTopic(@Value(value="${chain.main.role.topic}") String topicName, @Value(value="${chain.main.topic.partitions:2}") int partitions, @Value(value="${chain.main.topic.replication:1}") short replication) {
        return this.initCompactTopic(new NewTopic(topicName, partitions, replication));
    }

    protected NewTopic initTopic(NewTopic topic) {
        if (topic.configs() == null) {
            topic.configs(new HashMap());
        }
        return topic;
    }

    protected NewTopic initCompactTopic(NewTopic topic) {
        this.initTopic(topic).configs().put("cleanup.policy", "compact");
        return topic;
    }

    protected NewTopic initEventTopic(NewTopic topic) {
        this.initTopic(topic).configs().put("cleanup.policy", "delete");
        return topic;
    }
}

