/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.security.kafka.stream.OneTimePasswordSupportStream;
import java.util.List;
import java.util.Properties;
import java.util.function.BiPredicate;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class KafkaConfig
extends inc.yukawa.chain.security.kafka.config.KafkaConfig {
    @Bean(value={"kafkaTemplate", "initTemplate"})
    @Profile(value={"init", "init-roles"})
    public ReactiveKafkaProducerTemplate<String, Object> kafkaTemplate(KafkaProperties properties, ObjectMapper mapper) {
        return this.reactiveKafkaTemplate(properties, Serdes.String().serializer(), (Serializer)new JsonSerializer(mapper));
    }

    @Bean(value={"security.invalidatePassStreamsProps"})
    @Profile(value={"one-time-password"})
    public Properties invalidatePassStreamsProps() {
        Properties props = this.baseStreamsProps();
        props.put("topology.optimization", "all");
        props.put("application.id", this.appId + "-invalidatePass");
        return props;
    }

    @Bean
    @Profile(value={"one-time-password"})
    public OneTimePasswordSupportStream invalidatePassStream(@Qualifier(value="security.invalidatePassStreamsProps") Properties streamProps, @Qualifier(value="security.AccessEventTopic") NewTopic authEventTopic, @Qualifier(value="security.AccountTopic") NewTopic accountTopic, PasswordEncoder encoder, @Value(value="${chain.security.stream.invalidatePass.excludeUsers:admin") List<String> excludeUsers, @Value(value="${chain.security.account.details.oneTimePasswordKey:oneTimePassword}") String oneTimePasswordKey, ObjectMapper mapper) {
        BiPredicate filter = OneTimePasswordSupportStream.notExcludedAndHeavingOneTimePassword(excludeUsers, (String)oneTimePasswordKey);
        return new OneTimePasswordSupportStream(streamProps, authEventTopic, accountTopic, arg_0 -> ((PasswordEncoder)encoder).encode(arg_0), filter, mapper);
    }
}

