/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import inc.yukawa.chain.security.jwt.config.WebFluxSecurityBase;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
@Profile(value={"jwt", "!open"})
public class WebSecurityJwt
extends WebFluxSecurityBase {
    @Bean(value={"security.PermitEndpoints"})
    public List<String> permitAllEndpoints() {
        ArrayList<String> all = new ArrayList<String>(super.permitAllEndpoints());
        all.add("/oauth/token");
        all.add("/auth/token");
        all.add("/auth/login");
        all.add("/auth/refresh");
        return all;
    }

    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        return this.configureBase(http).authorizeExchange(e -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)e.pathMatchers(new String[]{"/auth/**"})).authenticated()).authorizeExchange(e -> e.anyExchange().hasAnyAuthority(new String[]{"ROLE_ADMIN", "ROLE_AUTH_ADMIN"})).build();
    }
}

