/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.base.mono.repos.MonoRepository;
import inc.yukawa.chain.security.jwt.token.JwsTokenFactory;
import inc.yukawa.chain.security.kafka.dao.AccountRepository2;
import inc.yukawa.chain.security.service.AccountService;
import inc.yukawa.chain.security.service.BaseRevocationService;
import inc.yukawa.chain.security.service.OrgTokenAuthService;
import inc.yukawa.chain.security.service.TokenFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
public class SecurityAspectsConfig
extends inc.yukawa.chain.security.kafka.config.SecurityAspectsConfig {
    @Bean(value={"security.TokenAuthAspect"})
    @Profile(value={"token-auth-aspect", "all-aspects", "default"})
    public OrgTokenAuthService tokenAuthService(ReactiveUserDetailsService userDetailsService, JwsTokenFactory tokenFactory, PasswordEncoder encoder) {
        return new OrgTokenAuthService(userDetailsService, (TokenFactory)tokenFactory, encoder);
    }

    @Bean(value={"security.AccountAspect"})
    @Profile(value={"token-auth-aspect", "all-aspects", "default"})
    public AccountService accountService(@Qualifier(value="security.AccountRepository") AccountRepository2 accountRepos, PasswordEncoder encoder) {
        return new AccountService((MonoRepository)accountRepos, encoder);
    }

    @Bean(value={"security.RevocationAspect"})
    @Profile(value={"token-auth-aspect", "all-aspects", "default"})
    public BaseRevocationService revocationService(@Qualifier(value="security.RevocationLoadDao") MonoLoadDao<String, String> revocationLoadDao, @Qualifier(value="security.RevocationWriteDao") MonoWriteDao<String, String> revocationWriteDao) {
        return new BaseRevocationService(revocationWriteDao, revocationLoadDao);
    }
}

