/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import inc.yukawa.chain.base.core.anno.ChainRequest;
import inc.yukawa.chain.base.core.domain.info.Info;
import inc.yukawa.chain.base.core.domain.module.AspectInfo;
import inc.yukawa.chain.base.core.domain.module.ModuleInfo;
import inc.yukawa.chain.base.core.service.ModuleAspect;
import inc.yukawa.chain.base.service.ModuleService;
import inc.yukawa.chain.base.service.config.ModAspectConfigBase;
import inc.yukawa.chain.base.service.util.ExtHostUtil;
import inc.yukawa.chain.base.service.util.ModUtil;
import inc.yukawa.chain.security.service.AccountAspect;
import inc.yukawa.chain.security.service.RevocationAspect;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"mod-aspect", "all-aspects", "default"})
public class SecurityModConfig
extends ModAspectConfigBase {
    @Bean
    public ModuleAspect modAspect(ModuleInfo info) {
        return new ModuleService(info);
    }

    @Bean
    public Set<AspectInfo> aspectInfos() {
        return Arrays.stream(new Class[]{AccountAspect.class, ModuleAspect.class, RevocationAspect.class}).map(cls -> {
            String apiUrl = this.apiUrl("security");
            String name = cls.getSimpleName().replace("Aspect", "");
            String reg = name.toLowerCase();
            Set requests = ModUtil.scanRequestNames((Class)cls, ChainRequest.class).toStream().collect(Collectors.toSet());
            return new AspectInfo(apiUrl + "/" + reg, new Info(name, reg, cls.getName()), requests);
        }).collect(Collectors.toSet());
    }

    @Bean
    public ModuleInfo moduleInfo(Set<AspectInfo> aspects) {
        String apiUrl = this.apiUrl("security");
        ModuleInfo modInfo = new ModuleInfo("Console Module", "security", null, apiUrl, "3.4.0");
        modInfo.setAspects(aspects);
        return modInfo;
    }

    protected String apiUrl(String reg) {
        return ExtHostUtil.getExtServiceUrl((String)this.extSchemes, (String)this.extHost, (int)this.extPort, (String)this.extPath);
    }
}

