/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.service.AccountAspect;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.crypto.password.PasswordEncoder;
import reactor.core.scheduler.Schedulers;

@Profile(value={"sample"})
@Configuration
public class SecuritySampleConfig {
    @Autowired
    private MonoWriteDao<String, Account> accountDao;
    @Autowired
    private AccountAspect accountAspect;

    @Bean(value={"sampleAccounts"})
    public List<Account> sampleAccounts(PasswordEncoder encoder) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.add(new Account(new Credentials("admin", "admin"), new String[]{"ROLE_ADMIN"}, true));
        accounts.add(new Account(new Credentials("user", "user"), new String[]{"ROLE_USER"}, true));
        accounts.add(new Account(new Credentials("guest", "guest"), new String[0], false));
        return accounts;
    }

    @Bean(value={"sampleCreator"})
    public ApplicationRunner sampleCreator(@Qualifier(value="sampleAccounts") List<Account> accounts) {
        return args -> accounts.stream().map(arg_0 -> ((AccountAspect)this.accountAspect).editAccount(arg_0)).forEach(u -> u.subscribeOn(Schedulers.boundedElastic()).subscribe());
    }
}

