/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config;

import inc.yukawa.chain.security.boot.config.WebSecurityJwt;
import java.util.Collections;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.server.SecurityWebFilterChain;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
@Profile(value={"open"})
public class WebSecurityOpen
extends WebSecurityJwt {
    @Override
    @Bean
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        return this.configureBase(http).authorizeExchange(e -> e.anyExchange().authenticated()).build();
    }

    public ReactiveAuthenticationManager authenticationManager() {
        return auth -> Mono.just((Object)new AnonymousAuthenticationToken(auth.getName(), (Object)"Anonymous", Collections.singletonList(new SimpleGrantedAuthority("ROLE_ADMIN"))));
    }
}

