/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.boot.config.init;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.kafka.config.KafkaInitConfigBase;
import inc.yukawa.chain.security.domain.RoleInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
@Profile(value={"init", "init-roles"})
public class InitRolesConfig
extends KafkaInitConfigBase<String> {
    private final NewTopic topic;

    @Autowired
    public InitRolesConfig(ObjectMapper mapper, @Qualifier(value="initTemplate") ReactiveKafkaProducerTemplate<String, Object> template, @Qualifier(value="main.RoleInfoTopic") NewTopic roleTopic) {
        super(mapper, template);
        this.topic = roleTopic;
    }

    @Bean
    protected ApplicationRunner sendRoles(@Value(value="classpath:/META-INF/init/init-roles-config.json") Resource res) {
        return args -> {
            TypeReference<List<RoleInfo>> typeRef = new TypeReference<List<RoleInfo>>(){};
            List<RoleInfo> dataList = super.parseObject(res, (TypeReference)typeRef).parallelStream().peek(data -> {
                if (data.getId() == null) {
                    data.setId(data.getShortName());
                }
            }).collect(Collectors.toList());
            dataList.forEach(data -> this.sendObject(this.topic.name(), data.getId(), data));
        };
    }
}

