/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.client;

import inc.yukawa.chain.security.client.ChainSecurityClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration
public class ChainSecurityClientConfig {
    @Value(value="${chain.security.url:http://security-service:3081}")
    public String securityBaseUrl;

    @Bean
    public ChainSecurityClient chainSecurityClient(WebClient.Builder builder) {
        WebClient webClient = builder.clone().baseUrl(this.securityBaseUrl).defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("Accept", new String[]{"application/json"}).filter(ExchangeFilterFunction.ofRequestProcessor(ChainSecurityClientConfig::propagateJwt)).build();
        return new ChainSecurityClient(webClient);
    }

    public static Mono<ClientRequest> propagateJwt(ClientRequest request) {
        return ReactiveSecurityContextHolder.getContext().map(securityContext -> {
            if (securityContext.getAuthentication() != null && securityContext.getAuthentication() instanceof AbstractAuthenticationToken) {
                Object token = securityContext.getAuthentication().getCredentials();
                return ClientRequest.from((ClientRequest)request).header("Authorization", new String[]{"Bearer " + token}).build();
            }
            return request;
        }).defaultIfEmpty((Object)request);
    }
}

