/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.base.core.domain.entity.Keyed;
import inc.yukawa.chain.security.domain.AccountStatus;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.RoleContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Schema
@XmlRootElement(name="account")
@XmlType(name="Account")
@JsonIgnoreProperties(ignoreUnknown=true)
public class Account
implements Serializable,
Keyed<String> {
    private static final long serialVersionUID = 20190724L;
    private Credentials credentials;
    @Deprecated
    private Set<String> roles;
    private Set<RoleContext> roleContexts;
    private AccountStatus status;
    private Instant passChangeDate;
    private Map<String, Object> details;

    public Account() {
    }

    public Account(String username) {
        this(new Credentials(username, null), null);
    }

    public Account(String username, String password, Set<String> authorities) {
        this(new Credentials(username, password), authorities);
    }

    public Account(String username, String password, String[] authorities) {
        this(username, password, new HashSet<String>(Arrays.asList(authorities)));
    }

    public Account(Credentials credentials, Set<String> roles) {
        this.credentials = credentials;
        this.roles = roles;
    }

    public Account(Credentials credentials, Set<String> roles, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this(credentials, roles, new AccountStatus(enabled, accountNonExpired, accountNonLocked, credentialsNonExpired));
    }

    public Account(Credentials credentials, Set<String> roles, boolean flag) {
        this(credentials, roles, new AccountStatus(flag, flag, flag, flag));
    }

    public Account(Credentials credentials, String[] roles, boolean flag) {
        this(credentials, new HashSet<String>(Arrays.asList(roles)), new AccountStatus(flag, flag, flag, flag));
    }

    public Account(Credentials credentials, Set<String> roles, AccountStatus status) {
        this(credentials, roles, status, null);
    }

    public Account(Credentials credentials, Set<String> roles, AccountStatus status, Map<String, Object> details) {
        this.credentials = credentials;
        this.roles = roles;
        this.status = status;
        this.details = details;
    }

    @XmlTransient
    @JsonIgnore
    public String getUsername() {
        return this.credentials != null ? this.credentials.getUsername() : null;
    }

    @XmlTransient
    @JsonIgnore
    public String getPassword() {
        return this.credentials != null ? this.credentials.getPassword() : null;
    }

    @XmlTransient
    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return this.status != null && this.status.getAccountNonExpired() != null && this.status.getAccountNonExpired() != false;
    }

    public void setAccountNonExpired(boolean value) {
        if (this.status == null) {
            this.status = new AccountStatus();
        }
        this.status.setAccountNonExpired(value);
    }

    @XmlTransient
    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return this.status != null && this.status.getAccountNonLocked() != null && this.status.getAccountNonLocked() != false;
    }

    public void setAccountNonLocked(boolean value) {
        if (this.status == null) {
            this.status = new AccountStatus();
        }
        this.status.setCredentialsNonExpired(value);
    }

    @XmlTransient
    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return this.status != null && this.status.getCredentialsNonExpired() != null && this.status.getCredentialsNonExpired() != false;
    }

    public void setCredentialsNonExpired(boolean value) {
        if (this.status == null) {
            this.status = new AccountStatus();
        }
        this.status.setCredentialsNonExpired(value);
    }

    @XmlTransient
    @Transient
    @JsonIgnore
    public boolean isEnabled() {
        return this.status != null && this.status.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.status == null) {
            this.status = new AccountStatus();
        }
        this.status.setEnabled(enabled);
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    @JsonProperty(value="roles")
    @Deprecated
    public Set<String> getRoles() {
        return this.roles;
    }

    @Deprecated
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @XmlElementWrapper(name="role-contexts")
    @XmlElement(name="context")
    @JsonProperty(value="roleContexts")
    public Set<RoleContext> getRoleContexts() {
        return this.roleContexts;
    }

    public void setRoleContexts(Set<RoleContext> roleContexts) {
        this.roleContexts = roleContexts;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public Instant getPassChangeDate() {
        return this.passChangeDate;
    }

    public void setPassChangeDate(Instant passChangeDate) {
        this.passChangeDate = passChangeDate;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    public String key() {
        return this.getUsername();
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.credentials != null) {
            sb.append(", credentials='").append(this.credentials).append('\'');
        }
        if (this.roles != null) {
            sb.append(", roles='").append(this.roles).append('\'');
        }
        if (this.roleContexts != null) {
            sb.append(", roleContexts='").append(this.roleContexts).append('\'');
        }
        if (this.status != null) {
            sb.append(", status='").append(this.status).append('\'');
        }
        if (this.details != null) {
            sb.append(", details='").append(this.details).append('\'');
        }
        return sb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account that = (Account)o;
        return Objects.equals(this.key(), that.key());
    }

    public int hashCode() {
        return Objects.hash(this.key());
    }
}

