/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
@XmlType(name="RoleContext")
public class RoleContext
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Schema(example="aaaa1111")
    private String userId;
    @Schema(title="OrgId")
    private String orgId;
    @Schema(title="Roles")
    private Set<String> roles;

    public RoleContext() {
    }

    public RoleContext(String orgId, Set<String> roles) {
        this.orgId = orgId;
        this.roles = roles;
    }

    public RoleContext(String orgId, String ... roles) {
        this.orgId = orgId;
        this.roles = new HashSet<String>(Arrays.asList(roles));
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public StringBuilder toStringFields(StringBuilder sb) {
        sb.append(", orgId=").append(this.orgId);
        if (this.userId != null) {
            sb.append(", userId=").append(this.userId);
        }
        if (this.roles != null) {
            sb.append(", roles=").append(this.roles);
        }
        return sb;
    }

    public String toString() {
        return this.toStringFields(new StringBuilder(this.getClass().getSimpleName()).append('{')).toString().replaceFirst(", ", "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleContext that = (RoleContext)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.orgId, that.orgId);
    }

    public int hashCode() {
        return Objects.hash(this.orgId);
    }
}

