/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.domain.GroupContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.Set;

@XmlRootElement(name="account-entity")
@XmlType(name="AccountEntity")
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccountEntity
extends Account {
    private static final long serialVersionUID = 20190724L;
    @Schema(example="aaaa1111")
    @JsonIgnore
    private String userId;
    @JsonIgnore
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="admin")
    private String username;
    @JsonIgnore
    @Schema(requiredMode=Schema.RequiredMode.REQUIRED, example="admin")
    private String password;
    @Schema(title="User groups context")
    @JsonIgnore
    private Set<GroupContext> groupContexts;
    @JsonIgnore
    @Schema(example="default")
    private String defaultOrgId;

    public AccountEntity() {
    }

    public AccountEntity(String username) {
        this.username = username;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<GroupContext> getGroupContexts() {
        return this.groupContexts;
    }

    public void setGroupContexts(Set<GroupContext> groupContexts) {
        this.groupContexts = groupContexts;
    }

    public String getDefaultOrgId() {
        return this.defaultOrgId;
    }

    public void setDefaultOrgId(String defaultOrgId) {
        this.defaultOrgId = defaultOrgId;
    }

    @Override
    @JsonProperty
    public Credentials getCredentials() {
        return new Credentials(this.username, this.password);
    }

    @Override
    public StringBuilder toStringFields(StringBuilder sb) {
        if (this.userId != null) {
            sb.append(", userId='").append(this.userId).append('\'');
        }
        if (this.username != null) {
            sb.append(", username='").append(this.username).append('\'');
        }
        if (this.password != null) {
            sb.append(", password='").append("***").append('\'');
        }
        super.toStringFields(sb);
        if (this.groupContexts != null) {
            sb.append(", groupContexts='").append(this.groupContexts).append('\'');
        }
        if (this.defaultOrgId != null) {
            sb.append(", defaultOrgId='").append(this.defaultOrgId).append('\'');
        }
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountEntity e = (AccountEntity)o;
        return this.userId != null && Objects.equals(this.userId, e.userId);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

