/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.data.config;

import inc.yukawa.chain.base.hibernate.repo.JpaRepo;
import inc.yukawa.chain.base.hibernate.repo.JpaWriteDao;
import inc.yukawa.chain.base.mono.dao.MonoReadDao;
import inc.yukawa.chain.security.data.repo.AccountReadDao;
import inc.yukawa.chain.security.data.repo.AccountRepo;
import inc.yukawa.chain.security.data.repo.AccountWriteDao;
import inc.yukawa.chain.security.data.repo.RevocationReadDao;
import inc.yukawa.chain.security.data.repo.RevocationWriteDao;
import inc.yukawa.chain.security.domain.AccountEntity;
import inc.yukawa.chain.security.domain.Revocation;
import inc.yukawa.chain.security.domain.RevocationFilter;
import inc.yukawa.chain.security.filter.AccountFilter;
import org.hibernate.reactive.mutiny.Mutiny;
import org.springframework.context.annotation.Bean;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import reactor.core.publisher.Mono;

public class RepoConfigBase {
    @Bean
    public AccountRepo accountRepo(Mutiny.SessionFactory sessionFactory) {
        return new AccountRepo((MonoReadDao<String, AccountEntity, AccountFilter>)new AccountReadDao(sessionFactory), (JpaWriteDao<String, AccountEntity>)new AccountWriteDao(sessionFactory));
    }

    @Bean
    public JpaRepo<Long, Revocation, RevocationFilter> revocationRepo(Mutiny.SessionFactory sessionFactory) {
        return new JpaRepo((MonoReadDao)new RevocationReadDao(sessionFactory), (JpaWriteDao)new RevocationWriteDao(sessionFactory), RepoConfigBase::authPrincipal);
    }

    public static Mono<String> authPrincipal() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication).map(a -> (String)a.getPrincipal());
    }
}

