/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.data.repo;

import inc.yukawa.chain.base.hibernate.repo.HibernateReactiveReadDao;
import inc.yukawa.chain.security.domain.AccountEntity;
import inc.yukawa.chain.security.domain.AccountStatus;
import inc.yukawa.chain.security.filter.AccountFilter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.reactive.mutiny.Mutiny;

public class AccountReadDao
extends HibernateReactiveReadDao<String, AccountEntity, AccountFilter> {
    public AccountReadDao(Mutiny.SessionFactory sessionFactory) {
        super(sessionFactory);
        this.setLoadGraphName("fullAccount");
    }

    protected void withFetch(CriteriaQuery<?> query, Root<AccountEntity> root, AccountFilter filter) {
        root.fetch("roleContexts", JoinType.LEFT).fetch("roles", JoinType.LEFT);
        root.fetch("groupContexts", JoinType.LEFT).fetch("groups", JoinType.LEFT);
        query.distinct(true);
    }

    protected List<Predicate> withPredicates(AccountFilter filter, Root<AccountEntity> root, CriteriaBuilder cb) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.whereEquals(predicates, cb, (Expression)root.get("userId"), () -> ((AccountFilter)filter).getUserId());
        this.whereEquals(predicates, cb, (Expression)root.get("username"), () -> ((AccountFilter)filter).getUsername());
        AccountStatus status = filter.getStatus();
        if (status != null) {
            Path path = root.get("status");
            this.whereEquals(predicates, cb, (Expression)path.get("enabled"), () -> ((AccountStatus)status).getEnabled());
            this.whereEquals(predicates, cb, (Expression)path.get("accountNonExpired"), () -> ((AccountStatus)status).getAccountNonExpired());
            this.whereEquals(predicates, cb, (Expression)path.get("accountNonLocked"), () -> ((AccountStatus)status).getAccountNonLocked());
            this.whereEquals(predicates, cb, (Expression)path.get("credentialsNonExpired"), () -> ((AccountStatus)status).getCredentialsNonExpired());
        }
        this.whereBetween(predicates, cb, (Expression)root.get("passChangeDate"), () -> ((AccountFilter)filter).getPassChangeDateRange());
        return predicates;
    }
}

