/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth;

import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.security.domain.Credentials;
import inc.yukawa.chain.security.externalauth.ExternalId;
import inc.yukawa.chain.security.externalauth.ExternalIdTokenService;
import inc.yukawa.chain.security.externalauth.apple.AppleIdTokenService;
import inc.yukawa.chain.security.externalauth.google.GoogleIdTokenService;
import io.jsonwebtoken.lang.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import reactor.core.publisher.Mono;

public class ExternalAuthService {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalAuthService.class);
    private final GoogleIdTokenService googleIdTokenService;
    private final AppleIdTokenService appleIdTokenService;

    public ExternalAuthService(@Autowired(required=false) GoogleIdTokenService googleIdTokenService, @Autowired(required=false) AppleIdTokenService appleIdTokenService) {
        this.googleIdTokenService = googleIdTokenService;
        this.appleIdTokenService = appleIdTokenService;
    }

    public Mono<ExternalId> login(Credentials credentials) {
        return this.obtainIdToken(credentials).flatMap(idToken -> this.readPerson((String)idToken, credentials.getProvider()).map(p -> new ExternalId((String)idToken, this.idTokenProvider(credentials), p.getEmail(), (Person)p)));
    }

    public Mono<String> obtainIdToken(Credentials credentials) {
        Assert.hasText((CharSequence)credentials.getPassword(), (String)"password (token) is required");
        Mono<String> idToken = "APPLE_AUTH_CODE".equalsIgnoreCase(credentials.getProvider()) ? this.serviceFor(credentials.getProvider()).obtainIdToken(credentials.getPassword()) : Mono.just((Object)credentials.getPassword());
        return idToken.flatMap(token -> this.readPerson((String)token, credentials.getProvider()).thenReturn(token));
    }

    public Mono<String> readUsername(String idToken, String provider) {
        return this.readPerson(idToken, provider).map(Person::getEmail);
    }

    public Mono<Person> readPerson(String idToken, String provider) {
        return this.serviceFor(provider).readPerson(idToken).switchIfEmpty(Mono.error((Throwable)new BadCredentialsException("invalid credentials")));
    }

    protected ExternalIdTokenService serviceFor(String provider) {
        ExternalIdTokenService service;
        Assert.hasText((CharSequence)provider, (String)"provider is required");
        switch (provider) {
            case "GOOGLE_ID_TOKEN": {
                ExternalIdTokenService externalIdTokenService = this.googleIdTokenService;
                break;
            }
            case "APPLE_ID_TOKEN": 
            case "APPLE_AUTH_CODE": {
                ExternalIdTokenService externalIdTokenService = this.appleIdTokenService;
                break;
            }
            default: {
                ExternalIdTokenService externalIdTokenService = service = null;
            }
        }
        if (service == null) {
            LOG.info("Unsupported or disabled auth for token provider: {}", (Object)provider);
            throw new BadCredentialsException("invalid credentials");
        }
        return service;
    }

    protected String idTokenProvider(Credentials credentials) {
        return "APPLE_AUTH_CODE".equalsIgnoreCase(credentials.getProvider()) ? "APPLE_ID_TOKEN" : credentials.getProvider();
    }
}

