/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth.apple;

import inc.yukawa.chain.security.externalauth.apple.AppleIdTokenParser;
import inc.yukawa.chain.security.externalauth.apple.AppleKeys;
import inc.yukawa.chain.security.externalauth.apple.TokenResponse;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.lang.NestedCollection;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class AppleIdClient {
    private static final Logger LOG = LoggerFactory.getLogger(AppleIdClient.class);
    private final WebClient webClient;
    private final String clientId;
    private final String keyId;
    private final String teamId;
    private final String appleId;
    private final String redirectUrl;
    private final PrivateKey pKey;
    private final AppleIdTokenParser appleIdTokenParser;

    public AppleIdClient(WebClient webClient, String clientId, String keyId, String teamId, String pkCert, String appleId, String redirectUrl) {
        this.webClient = webClient;
        this.clientId = clientId;
        this.keyId = keyId;
        this.teamId = teamId;
        this.appleId = appleId;
        this.redirectUrl = redirectUrl;
        this.pKey = AppleIdClient.generatePrivateKey(pkCert);
        this.appleIdTokenParser = new AppleIdTokenParser(appleId, clientId, this.getAppleKeys());
    }

    public Mono<Jws<Claims>> parseIdToken(String idToken) {
        return this.appleIdTokenParser.parse(idToken);
    }

    public Mono<String> getIdToken(String authCode) {
        return this.getAuthToken(authCode).map(TokenResponse::id_token);
    }

    public Mono<TokenResponse> getAuthToken(String authCode) {
        String token = this.generateVerificationToken();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        formParams.add((Object)"client_id", (Object)this.clientId);
        formParams.add((Object)"client_secret", (Object)token);
        formParams.add((Object)"grant_type", (Object)"authorization_code");
        formParams.add((Object)"code", (Object)authCode);
        if (StringUtils.hasText((String)this.redirectUrl)) {
            formParams.add((Object)"redirect_uri", (Object)this.redirectUrl);
        }
        BodyInserters.FormInserter body = BodyInserters.fromFormData((MultiValueMap)formParams);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri("/auth/token", new Object[0])).headers(header -> header.setContentType(MediaType.APPLICATION_FORM_URLENCODED))).body((BodyInserter)body).retrieve().bodyToMono(TokenResponse.class).doOnNext(t -> LOG.debug("Got new token response which expires in {}", (Object)t.expires_in())).doOnError(WebClientResponseException.class, e -> LOG.warn("Error response --> code: {} --> body: {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString()));
    }

    public Mono<AppleKeys> getAppleKeys() {
        return this.webClient.get().uri("/auth/keys", new Object[0]).retrieve().bodyToMono(AppleKeys.class).doOnNext(r -> LOG.debug("Got apple keys response {}", r)).doOnError(WebClientResponseException.class, e -> LOG.warn("Error response --> code: {} --> body: {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString()));
    }

    private String generateVerificationToken() {
        return ((JwtBuilder)((NestedCollection)((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().keyId(this.keyId)).and()).issuer(this.teamId).audience().add((Object)this.appleId)).and()).subject(this.clientId).expiration(Date.from(Instant.now().plusSeconds(300L))).issuedAt(Date.from(Instant.now())).signWith((Key)this.pKey).compact();
    }

    public static PrivateKey generatePrivateKey(String pkCert) {
        try {
            Pattern parse = Pattern.compile("(?m)(?s)^---*BEGIN.*---*$(.*)^---*END.*---*$.*");
            String encoded = parse.matcher(pkCert).replaceFirst("$1");
            encoded = encoded.replaceAll("\\s", "");
            KeyFactory kf = KeyFactory.getInstance("EC");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(encoded)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PublicKey asPublicKey(AppleKeys.AppleKey key) {
        BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(key.n()));
        BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(key.e()));
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            LOG.warn("Unable to parse apple public key: {}", (Object)key, (Object)ex);
            throw new IllegalStateException(ex);
        }
    }
}

