/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth.apple;

import inc.yukawa.chain.security.externalauth.apple.AppleIdClient;
import inc.yukawa.chain.security.externalauth.apple.AppleKeys;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.jsonwebtoken.ProtectedHeader;
import java.security.Key;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class AppleIdTokenParser {
    private final Mono<JwtParser> parser;

    public AppleIdTokenParser(String issuer, String clientId, Mono<AppleKeys> appleKeys) {
        Mono appleKeyLocator = appleKeys.map(this::asKeyLocator).cache(token -> Duration.ofHours(1L), throwable -> Duration.ZERO, () -> Duration.ZERO);
        this.parser = appleKeyLocator.map(keyLocator -> Jwts.parser().keyLocator(keyLocator).requireIssuer(issuer).requireAudience(clientId).clockSkewSeconds(10L).build());
    }

    public Mono<Jws<Claims>> parse(String idToken) {
        return this.parser.map(p -> p.parseSignedClaims((CharSequence)idToken));
    }

    private Locator<Key> asKeyLocator(AppleKeys keys) {
        final Map<String, PublicKey> kidToPubKey = keys.keys().stream().collect(Collectors.toMap(AppleKeys.AppleKey::kid, AppleIdClient::asPublicKey));
        return new LocatorAdapter<Key>(){

            protected Key locate(ProtectedHeader header) {
                return (Key)kidToPubKey.get(header.getKeyId());
            }
        };
    }
}

