/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth.apple;

import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.security.externalauth.ExternalIdTokenService;
import inc.yukawa.chain.security.externalauth.apple.AppleIdClient;
import io.jsonwebtoken.Claims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AppleIdTokenService
implements ExternalIdTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(AppleIdTokenService.class);
    private final AppleIdClient client;

    public AppleIdTokenService(AppleIdClient client) {
        this.client = client;
    }

    @Override
    public Mono<String> obtainIdToken(String authCode) {
        return this.client.getIdToken(authCode);
    }

    @Override
    public Mono<Person> readPerson(String idToken) {
        return this.client.parseIdToken(idToken).map(jwt -> {
            Claims payload = (Claims)jwt.getPayload();
            String email = (String)payload.get("email", String.class);
            LOG.debug("idToken verification success, subject: {}, email: {}", (Object)payload.getSubject(), (Object)email);
            Person p = new Person();
            p.setEmail(email);
            p.setShortName(payload.getSubject());
            return p;
        }).onErrorResume(e -> {
            LOG.info("Invalid idToken: {}", (Object)e.getMessage());
            return Mono.empty();
        });
    }
}

