/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth.config;

import inc.yukawa.chain.security.externalauth.ExternalAuthService;
import inc.yukawa.chain.security.externalauth.apple.AppleIdClient;
import inc.yukawa.chain.security.externalauth.apple.AppleIdTokenService;
import inc.yukawa.chain.security.externalauth.google.GoogleIdTokenService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;

public class ExternalAuthConfigBase {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalAuthConfigBase.class);
    @Value(value="${chain.security.externalAuth.google.audience:#{null}}")
    private List<String> audience;
    @Value(value="${chain.security.externalAuth.google.issuers:#{null}}")
    private List<String> issuers;
    @Value(value="${chain.security.externalAuth.apple.baseUrl:https://appleid.apple.com}")
    private String appleAuthBaseUrl;
    @Value(value="${chain.security.externalAuth.apple.clientId:#{null}}")
    private String clientId;
    @Value(value="${chain.security.externalAuth.apple.keyId:#{null}}")
    private String keyId;
    @Value(value="${chain.security.externalAuth.apple.teamId:#{null}}")
    private String teamId;
    @Value(value="${chain.security.externalAuth.apple.pkCert:#{null}}")
    private String pkCert;
    @Value(value="${chain.security.externalAuth.apple.appleId:https://appleid.apple.com}")
    private String appleId;
    @Value(value="${chain.security.externalAuth.apple.redirectUrl:#{null}}")
    private String redirectUrl;

    @Bean
    public ExternalAuthService externalAuthService(@Autowired(required=false) GoogleIdTokenService googleIdTokenService, @Autowired(required=false) AppleIdTokenService appleIdTokenService) {
        LOG.info("ExternalAuthService is enabled");
        return new ExternalAuthService(googleIdTokenService, appleIdTokenService);
    }

    @Bean
    public GoogleIdTokenService googleIdTokenService() {
        LOG.info("GoogleIdTokenService is enabled");
        return new GoogleIdTokenService(this.audience, this.issuers);
    }

    @Bean
    public AppleIdTokenService appleIdTokenService(AppleIdClient appleIdClient) {
        LOG.info("AppleIdTokenService is enabled");
        return new AppleIdTokenService(appleIdClient);
    }

    @Bean
    public AppleIdClient appleIdClient() {
        WebClient webClient = WebClient.builder().baseUrl(this.appleAuthBaseUrl).defaultHeaders(header -> header.setAccept(List.of(MediaType.APPLICATION_JSON))).defaultHeaders(header -> header.setContentType(MediaType.APPLICATION_JSON)).build();
        return new AppleIdClient(webClient, this.clientId, this.keyId, this.teamId, this.pkCert, this.appleId, this.redirectUrl);
    }
}

