/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.externalauth.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import inc.yukawa.chain.base.core.domain.person.Person;
import inc.yukawa.chain.security.externalauth.ExternalIdTokenService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import reactor.core.publisher.Mono;

public class GoogleIdTokenService
implements ExternalIdTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleIdTokenService.class);
    private final HttpTransport transport = new NetHttpTransport();
    private final JsonFactory jsonFactory = new GsonFactory();
    private final GoogleIdTokenVerifier verifier;

    public GoogleIdTokenService(@Value(value="${chain.security.googleIdToken.audience}") List<String> audience, @Value(value="${chain.security.googleIdToken.issuers:#{null}}") List<String> issuers) {
        this.verifier = new GoogleIdTokenVerifier.Builder(this.transport, this.jsonFactory).setAudience(audience).setIssuers(issuers).build();
    }

    @Override
    public Mono<String> obtainIdToken(String secret) {
        return Mono.just((Object)secret);
    }

    @Override
    public Mono<Person> readPerson(String idToken) {
        return Mono.just((Object)idToken).mapNotNull(this::readAsPerson);
    }

    public Person readAsPerson(String idToken) {
        try {
            GoogleIdToken token = this.verifier.verify(idToken);
            if (token == null) {
                LOG.info("invalid idToken");
                return null;
            }
            GoogleIdToken.Payload payload = token.getPayload();
            LOG.debug("idToken verification success, subject: {}, email: {}", (Object)payload.getSubject(), (Object)payload.getEmail());
            Person p = new Person();
            p.setEmail(payload.getEmail());
            p.setFirstName((String)payload.get((Object)"given_name"));
            p.setLastName((String)payload.get((Object)"family_name"));
            p.setLang((String)payload.get((Object)"locale"));
            p.setShortName(payload.getSubject());
            return p;
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.warn("IdToken read error: ", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("unparsable token");
            return null;
        }
    }
}

