/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.config;

import inc.yukawa.chain.base.core.anno.ChainRequest;
import inc.yukawa.chain.security.jwt.util.AuthContextHelper;
import inc.yukawa.chain.security.jwt.util.ChainSpringPrincipal;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import inc.yukawa.chain.security.principal.ChainSecurity;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SecurityAdviceBase {
    private static final Logger log = LoggerFactory.getLogger(SecurityAdviceBase.class);
    protected final String moduleReg;
    protected ChainSecurity chainSecurity;
    protected AuthContextHelper authContext = new AuthContextHelper();

    public SecurityAdviceBase() {
        this.moduleReg = "security";
    }

    public SecurityAdviceBase(String moduleReg) {
        this.moduleReg = moduleReg;
    }

    public SecurityAdviceBase(String moduleReg, ChainSecurity chainSecurity) {
        this.moduleReg = moduleReg;
        this.chainSecurity = chainSecurity;
    }

    protected String findReqName(MethodSignature methodSignature, ChainRequest reqAno) {
        String reqName = "".equals(reqAno.value()) ? methodSignature.getName() : reqAno.value();
        return reqName;
    }

    @Around(value="execution(reactor.core.publisher.Mono+ *(..)) && @annotation(inc.yukawa.chain.base.core.anno.ChainRequest)")
    public Mono<?> aroundMonoReq(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        ChainRequest reqAno = methodSignature.getMethod().getAnnotation(ChainRequest.class);
        String reqName = this.findReqName(methodSignature, reqAno);
        String clsName = methodSignature.getDeclaringType().getSimpleName();
        log.debug("@MonoReq: {}:{} on {} with {}", new Object[]{this.moduleReg, reqName, clsName, joinPoint.getArgs()});
        return this.authContext.auth().map(authentication -> this.chainSecurity.checkCall(reqName, joinPoint.getArgs(), (ChainPrincipal)new ChainSpringPrincipal((Authentication)authentication))).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.chainSecurity.checkCall(reqName, joinPoint.getArgs(), null)))).flatMap(args -> {
            log.debug("aroundMonoReq: {}:{} on {} with {}", new Object[]{this.moduleReg, reqName, clsName, args});
            try {
                return (Mono)joinPoint.proceed(args);
            }
            catch (Throwable throwable) {
                return Mono.error((Throwable)throwable);
            }
        });
    }

    @Around(value="execution(reactor.core.publisher.Flux+ *(..)) && @annotation(inc.yukawa.chain.base.core.anno.ChainRequest)")
    public Flux<?> aroundFluxReq(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        ChainRequest reqAno = methodSignature.getMethod().getAnnotation(ChainRequest.class);
        String reqName = this.findReqName(methodSignature, reqAno);
        String clsName = methodSignature.getDeclaringType().getSimpleName();
        log.debug("@FluxReq: {}:{} on {} with {}", new Object[]{this.moduleReg, reqName, clsName, joinPoint.getArgs()});
        return this.authContext.auth().map(authentication -> this.chainSecurity.checkCall(reqName, joinPoint.getArgs(), (ChainPrincipal)new ChainSpringPrincipal((Authentication)authentication))).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.chainSecurity.checkCall(reqName, joinPoint.getArgs(), null)))).flatMapMany(args -> {
            try {
                return (Flux)joinPoint.proceed(args);
            }
            catch (Throwable throwable) {
                return Flux.error((Throwable)throwable);
            }
        });
    }

    @Around(value="!execution(reactor.core.publisher.Flux+ *(..)) && !execution(reactor.core.publisher.Mono+ *(..)) && @annotation(inc.yukawa.chain.base.core.anno.ChainRequest)")
    public Object aroundChainReq(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        ChainRequest reqAno = methodSignature.getMethod().getAnnotation(ChainRequest.class);
        String reqName = this.findReqName(methodSignature, reqAno);
        String clsName = methodSignature.getDeclaringType().getSimpleName();
        log.debug("@SyncReq: {}:{} on {} with {}", new Object[]{this.moduleReg, reqName, clsName, joinPoint.getArgs()});
        ChainSpringPrincipal principal = new ChainSpringPrincipal(SecurityContextHolder.getContext().getAuthentication());
        return joinPoint.proceed(this.chainSecurity.checkCall(reqName, joinPoint.getArgs(), (ChainPrincipal)principal));
    }
}

