/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.config;

import inc.yukawa.chain.security.jwt.flux.JwtFluxAuthenticationManager;
import inc.yukawa.chain.security.jwt.flux.JwtFluxSecurityContextRepository;
import inc.yukawa.chain.security.jwt.token.JwsTokenReader;
import inc.yukawa.chain.security.jwt.util.AuthContextHelper;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import reactor.core.publisher.Mono;

public abstract class WebFluxSecurityBase {
    @Autowired(required=false)
    protected JwsTokenReader tokenReader;

    @Bean
    public AuthContextHelper authContext() {
        return new AuthContextHelper();
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public ReactiveAuthenticationManager authenticationManager() {
        return new JwtFluxAuthenticationManager(this.tokenReader);
    }

    @Bean
    public ServerSecurityContextRepository securityContextRepository() {
        return new JwtFluxSecurityContextRepository(this.authenticationManager());
    }

    protected ServerHttpSecurity configureAuthenticated(ServerHttpSecurity http) {
        return this.configureBase(http).authorizeExchange(e -> e.anyExchange().authenticated());
    }

    protected ServerHttpSecurity configureOpen(ServerHttpSecurity http) {
        return http.csrf(ServerHttpSecurity.CsrfSpec::disable).authorizeExchange(e -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)e.pathMatchers(new String[]{"/**"})).permitAll());
    }

    protected ServerHttpSecurity configureBase(ServerHttpSecurity http) {
        String[] permitAll = this.permitAllEndpoints().toArray(new String[0]);
        http.exceptionHandling(c -> c.authenticationEntryPoint((swe, e) -> Mono.fromRunnable(() -> swe.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED))).accessDeniedHandler((swe, e) -> Mono.fromRunnable(() -> swe.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN)))).csrf(ServerHttpSecurity.CsrfSpec::disable).formLogin(ServerHttpSecurity.FormLoginSpec::disable).httpBasic(ServerHttpSecurity.HttpBasicSpec::disable).authenticationManager(this.authenticationManager()).securityContextRepository(this.securityContextRepository()).authorizeExchange(e -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)e.pathMatchers(HttpMethod.OPTIONS)).permitAll().pathMatchers(permitAll)).permitAll());
        return http;
    }

    public List<String> permitAllEndpoints() {
        return Arrays.asList("/error**", "/webjars/**", "/swagger.json", "/swagger-ui.html**", "/swagger-resources/**", "/v3/**", "/v2/api-docs", "/v2/api-docs/**", "/swagger-ui/**");
    }

    protected Mono<AuthorizationDecision> matchAuthority(Mono<Authentication> mono, String regEx) {
        return mono.map(auth -> auth.getAuthorities().stream().anyMatch(e -> e.getAuthority().matches(regEx))).map(AuthorizationDecision::new);
    }

    protected Mono<AuthorizationDecision> hasAnyAuthority(Mono<Authentication> mono, String ... authorities) {
        return this.matchAuthority(mono, String.join((CharSequence)"|", authorities));
    }
}

