/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.security.jwt.token.json.JsonWebTokenReader;
import inc.yukawa.chain.security.jwt.token.json.JwtAuthenticationProvider;
import inc.yukawa.chain.security.jwt.token.json.JwtTokenAuthenticationProcessingFilter;
import inc.yukawa.chain.security.jwt.web.AjaxAwareAuthenticationFailureHandler;
import inc.yukawa.chain.security.jwt.web.SkipPathRequestMatcher;
import inc.yukawa.chain.security.jwt.web.TokenHeaderExtractor;
import inc.yukawa.chain.security.service.TokenExtractor;
import inc.yukawa.chain.security.service.TokenReader;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class WebSecurityConfigBase {
    @Value(value="${chain.security.web.api.root:/**}")
    protected String API_ROOT_URL = "/**";
    @Autowired
    protected AuthenticationManager authenticationManager;
    @Autowired
    protected JwtAuthenticationProvider jwtAuthenticationProvider;
    @Autowired
    protected ObjectMapper objectMapper;

    protected JwtTokenAuthenticationProcessingFilter buildJwtTokenAuthenticationProcessingFilter(List<String> pathsToSkip, String pattern) {
        SkipPathRequestMatcher matcher = new SkipPathRequestMatcher(pathsToSkip, pattern);
        JwtTokenAuthenticationProcessingFilter filter = new JwtTokenAuthenticationProcessingFilter(this.authenticationFailureHandler(), this.tokenExtractor(), matcher);
        filter.setAuthenticationManager(this.authenticationManager);
        return filter;
    }

    @Bean
    public TokenExtractor tokenExtractor() {
        return new TokenHeaderExtractor();
    }

    @Bean
    public TokenReader tokenReader(@Value(value="${chain.security.jwt.signingKey}") String signKey) {
        return new JsonWebTokenReader(signKey);
    }

    @Bean
    public AuthenticationFailureHandler authenticationFailureHandler() {
        return new AjaxAwareAuthenticationFailureHandler(this.objectMapper);
    }

    @Bean
    protected JwtAuthenticationProvider jwtAuthenticationProvider(TokenReader tokenReader) {
        return new JwtAuthenticationProvider(tokenReader);
    }

    protected List<String> permitAllEndpoints() {
        return Arrays.asList("/error", "/webjars/**", "/swagger.json", "/swagger-ui.html**", "/swagger-resources/**", "/v2/api-docs", "/v2/api-docs/**");
    }

    protected HttpSecurity configureBase(HttpSecurity http) throws Exception {
        return http.csrf(AbstractHttpConfigurer::disable).formLogin(AbstractHttpConfigurer::disable).httpBasic(AbstractHttpConfigurer::disable).exceptionHandling(c -> c.authenticationEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint())).authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(this.permitAllEndpoints().toArray(new String[0]))).permitAll()).sessionManagement(c -> c.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
    }

    protected WebSecurity.IgnoredRequestConfigurer configureOpen(WebSecurity web) {
        return (WebSecurity.IgnoredRequestConfigurer)web.ignoring().anyRequest();
    }

    protected UrlBasedCorsConfigurationSource corsConfiguration() {
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(36000L));
        config.setAllowedMethods(Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return source;
    }

    protected AuthenticationManagerBuilder configureBase(AuthenticationManagerBuilder auth) throws Exception {
        return auth.authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider).eraseCredentials(false);
    }
}

