/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.encoder;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PbePasswordEncoder
implements PasswordEncoder {
    private String secret;
    private Integer iteration;
    private Integer keyLength;
    private String provider = "PBKDF2WithHmacSHA512";

    public PbePasswordEncoder() {
    }

    public PbePasswordEncoder(String secret, Integer iteration, Integer keyLength) {
        this.secret = secret;
        this.iteration = iteration;
        this.keyLength = keyLength;
    }

    public PbePasswordEncoder(String secret, Integer iteration, Integer keyLength, String provider) {
        this.secret = secret;
        this.iteration = iteration;
        this.keyLength = keyLength;
        this.provider = provider;
    }

    public String encode(CharSequence cs) {
        try {
            byte[] raw = cs.toString().getBytes();
            byte[] result = SecretKeyFactory.getInstance(this.provider).generateSecret(new PBEKeySpec(cs.toString().toCharArray(), this.secret.getBytes(), this.iteration, this.keyLength)).getEncoded();
            return Base64.getEncoder().encodeToString(result);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean matches(CharSequence cs, String string) {
        return this.encode(cs).equals(string);
    }
}

