/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.flux;

import java.util.ArrayList;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class HttpHeaderPreAuthSecurityContextRepository
implements ServerSecurityContextRepository {
    private final String headerName;
    private final List<GrantedAuthority> grantedAuthorities;

    public HttpHeaderPreAuthSecurityContextRepository(String headerName, String ... grantedAuthorities) {
        this.headerName = headerName;
        this.grantedAuthorities = AuthorityUtils.createAuthorityList((String[])grantedAuthorities);
    }

    public Mono<Void> save(ServerWebExchange serverWebExchange, SecurityContext securityContext) {
        return Mono.empty();
    }

    public Mono<SecurityContext> load(ServerWebExchange serverWebExchange) {
        return Mono.justOrEmpty((Object)serverWebExchange.getRequest().getHeaders().getFirst(this.headerName)).filter(StringUtils::hasText).zipWhen(this::principalFromHeader).map(t -> new PreAuthenticatedAuthenticationToken(t.getT2(), t.getT2(), new ArrayList<GrantedAuthority>(this.grantedAuthorities))).map(authToken -> new SecurityContextImpl((Authentication)authToken));
    }

    protected Mono<String> principalFromHeader(String headerValue) {
        return Mono.just((Object)headerValue);
    }
}

