/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.flux;

import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import inc.yukawa.chain.security.service.TokenReader;
import jakarta.annotation.PostConstruct;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import reactor.core.publisher.Mono;

public class JwtFluxAuthenticationManager
implements ReactiveAuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(JwtFluxAuthenticationManager.class);
    private final TokenReader tokenReader;

    public JwtFluxAuthenticationManager(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
    }

    @PostConstruct
    public void init() {
        log.debug("init: tokenReader {}", (Object)this.tokenReader);
        Objects.requireNonNull(this.tokenReader, this.getClass().getSimpleName() + ".tokenReader");
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        log.trace("authenticate: authentication = {}", (Object)authentication);
        return Mono.just((Object)authentication).map(authentication1 -> authentication.getCredentials().toString()).flatMap(arg_0 -> ((TokenReader)this.tokenReader).parseTokenAsync(arg_0)).map(access -> {
            log.trace("authenticate: access {}", access);
            String username = access.getSubject();
            List roles = access.getRoles();
            List authorities = roles != null ? roles.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList()) : Collections.emptyList();
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)username, (Object)access.getToken(), authorities);
            auth.setDetails((Object)access.getDetails());
            log.debug("auth: {} {} {}", new Object[]{auth.getName(), auth.getAuthorities(), auth.getDetails()});
            return auth;
        });
    }

    public Mono<Authentication> authenticate_OLD(Authentication authentication) {
        log.debug("authenticate: authentication = {}", (Object)authentication);
        String authToken = authentication.getCredentials().toString();
        try {
            AccessToken access = this.tokenReader.parseToken(authToken);
            log.debug("authenticate_OLD: access {}", (Object)access);
            String username = access.getSubject();
            List authorities = access.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
            JsonWebAuthenticationToken auth = new JsonWebAuthenticationToken(username, authToken, access.getDetails(), authorities);
            log.debug("authenticate: {}", (Object)auth);
            return Mono.just((Object)((Object)auth));
        }
        catch (Exception e) {
            log.debug(e.getClass().getSimpleName() + " authenticating " + authentication.getName() + " token : " + e.getMessage());
            return Mono.empty();
        }
    }
}

