/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.flux;

import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtFluxSecurityContextRepository
implements ServerSecurityContextRepository {
    private static final Logger log = LoggerFactory.getLogger(JwtFluxSecurityContextRepository.class);
    private final ReactiveAuthenticationManager authenticationManager;
    private final String headerName = "Authorization";
    private final String cookieName = "AccessToken";

    public JwtFluxSecurityContextRepository(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public Mono<Void> save(ServerWebExchange swe, SecurityContext context) {
        log.debug("save: {}", (Object)swe.getRequest().getPath());
        throw new UnsupportedOperationException("JwtFluxSecurityContextRepository.save not implemented");
    }

    public Mono<SecurityContext> load(ServerWebExchange swe) {
        ServerHttpRequest request = swe.getRequest();
        log.debug("load: {} {}", (Object)request.getMethod(), (Object)request.getPath());
        String authToken = this.extractToken(request);
        if (authToken != null) {
            JsonWebAuthenticationToken auth = new JsonWebAuthenticationToken(authToken);
            return this.authenticationManager.authenticate((Authentication)auth).map(authentication -> new SecurityContextImpl(authentication)).onErrorMap(ex -> ex instanceof AuthenticationException, authEx -> new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, authEx.getMessage(), authEx));
        }
        return Mono.empty();
    }

    protected String extractToken(ServerHttpRequest request) {
        if ("Authorization" != null && request.getHeaders().containsKey((Object)"Authorization")) {
            log.trace("Extract Token: header = {}", (Object)"Authorization");
            String authHeader = request.getHeaders().getFirst("Authorization");
            if (authHeader != null && authHeader.startsWith("Bearer ")) {
                return authHeader.substring(7);
            }
        }
        if ("AccessToken" != null && request.getCookies().containsKey((Object)"AccessToken")) {
            HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)"AccessToken");
            log.trace("Extract Token: cookie {}", (Object)"AccessToken");
            if (cookie != null) {
                return cookie.getValue();
            }
        }
        return null;
    }
}

