/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.flux;

import inc.yukawa.chain.security.jwt.flux.HttpHeaderPreAuthSecurityContextRepository;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SubjectDnFromHttpHeaderPreAuthSecurityContextRepository
extends HttpHeaderPreAuthSecurityContextRepository {
    public static final String DEFAULT_SSL_CLIENT_SUBJECT_DN = "ssl-client-subject-dn";
    private static final Logger LOG = LoggerFactory.getLogger(SubjectDnFromHttpHeaderPreAuthSecurityContextRepository.class);

    public SubjectDnFromHttpHeaderPreAuthSecurityContextRepository(String[] grantedAuthorities) {
        this(DEFAULT_SSL_CLIENT_SUBJECT_DN, grantedAuthorities);
    }

    public SubjectDnFromHttpHeaderPreAuthSecurityContextRepository(String headerName, String ... grantedAuthorities) {
        super(headerName, grantedAuthorities);
    }

    @Override
    protected Mono<String> principalFromHeader(String headerValue) {
        try {
            return Mono.justOrEmpty(new LdapName(headerValue).getRdns().stream().filter(i -> i.getType().equalsIgnoreCase("CN")).findFirst().map(Rdn::getValue).map(Object::toString));
        }
        catch (InvalidNameException e) {
            LOG.warn("Failed to extract commonName from headerValue: " + headerValue, (Throwable)e);
            return Mono.empty();
        }
    }
}

