/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.roles;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.security.domain.RoleInfo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.Resource;

@Deprecated
public abstract class InitRolesConfigBase {
    private static final Logger log = LoggerFactory.getLogger(InitRolesConfigBase.class);
    protected final ObjectMapper mapper;
    protected final MonoWriteDao<String, RoleInfo> writeDao;

    public InitRolesConfigBase(ObjectMapper mapper, MonoWriteDao<String, RoleInfo> writeDao) {
        this.mapper = mapper;
        this.writeDao = writeDao;
    }

    @Bean
    public List<RoleInfo> parseRoles(@Value(value="classpath:/META-INF/init-roles-config.json") Resource res) {
        try {
            List rolesList = (List)this.mapper.readValue(res.getFile(), (TypeReference)new TypeReference<List<RoleInfo>>(){});
            log.debug("Read {} roles", (Object)rolesList.size());
            return rolesList;
        }
        catch (Exception e) {
            log.error("{} while mapping a JSON String to {} list: {}", new Object[]{e.getClass().getSimpleName(), RoleInfo.class, e});
            return new ArrayList<RoleInfo>();
        }
    }

    @Bean
    public ApplicationRunner sendRolesToTopic(List<RoleInfo> roleInfos) {
        return args -> roleInfos.stream().peek(roleInfo -> {
            if (roleInfo.getId() == null) {
                roleInfo.setId(roleInfo.getShortName());
            }
        }).forEach(t -> this.writeDao.put((Object)t.getId(), t).subscribe(o -> log.info("Successfully persisted RoleInfo with shortName {}", (Object)o.getShortName()), throwable -> log.error("Error while persisting RoleInfos: {}", (Object)throwable.getMessage())));
    }
}

