/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.token.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import inc.yukawa.chain.security.jwt.token.JwsAccessToken;
import io.jsonwebtoken.Claims;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import java.util.List;
import java.util.Map;

@XmlType(name="JsonWebAccessToken")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema
public class JsonWebAccessToken
implements JwsAccessToken {
    private String rawToken;
    @JsonIgnore
    @XmlTransient
    private Claims claims;

    public JsonWebAccessToken() {
    }

    public JsonWebAccessToken(String token, Claims claims) {
        this.rawToken = token;
        this.claims = claims;
    }

    public String getToken() {
        return this.rawToken;
    }

    public String getSubject() {
        return this.claims.getSubject();
    }

    public Claims getClaims() {
        return this.claims;
    }

    public String toString() {
        return "JsonWebAccessToken{" + this.rawToken + "}";
    }

    public Date getExpiration() {
        return this.claims.getExpiration();
    }

    public List<String> getRoles() {
        return this.get("scope", List.class);
    }

    public Map<String, Object> getDetails() {
        return this.get("details", Map.class);
    }

    protected <D> D get(String name, Class<D> cls) {
        return (D)this.claims.get(name, cls);
    }

    public String getId() {
        return this.claims.getId();
    }

    public String getOrgId() {
        try {
            return (String)this.getDetails().get("orgId");
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getIssuedAt() {
        return this.claims.getIssuedAt();
    }
}

