/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.token.json;

import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.jwt.config.JwtSettings;
import inc.yukawa.chain.security.jwt.token.JwsAccessToken;
import inc.yukawa.chain.security.jwt.token.JwsTokenFactory;
import inc.yukawa.chain.security.jwt.token.JwsTokenRevoker;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAccessToken;
import inc.yukawa.chain.security.jwt.token.json.JsonWebTokenReader;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ClaimsBuilder;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="security.JwtTokenFactory")
public class JsonWebTokenFactory
extends JsonWebTokenReader
implements JwsTokenFactory<Authentication, JwsAccessToken> {
    private static final Logger log = LoggerFactory.getLogger(JsonWebTokenFactory.class);
    private final JwtSettings settings;
    private final JwsTokenRevoker revocationHandler;

    public JsonWebTokenFactory(JwtSettings settings, @Autowired(required=false) JwsTokenRevoker revocationHandler) {
        super(settings.getSigningKey());
        this.settings = settings;
        this.revocationHandler = revocationHandler;
    }

    public JsonWebAccessToken createRefreshToken(Authentication auth) {
        LocalDateTime currentTime = LocalDateTime.now();
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)((ClaimsBuilder)((ClaimsBuilder)Jwts.claims().subject(auth.getName())).issuedAt(Date.from(currentTime.atZone(ZoneId.systemDefault()).toInstant()))).id(UUID.randomUUID().toString());
        if (this.settings.getRefreshTokenExpMinutes() >= 0) {
            claimsBuilder.expiration(Date.from(currentTime.plusMinutes(this.settings.getRefreshTokenExpMinutes().intValue()).atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (this.settings.getTokenIssuer() != null) {
            claimsBuilder.issuer(this.settings.getTokenIssuer());
        }
        claimsBuilder.add((Object)"scope", Collections.singletonList(this.settings.getRefreshTokenRole()));
        if (auth.getDetails() != null) {
            claimsBuilder.add((Object)"details", this.mapDetails(auth));
        }
        byte[] keyBytes = this.settings.getSigningKey().getBytes();
        Claims claims = (Claims)claimsBuilder.build();
        JwtBuilder builder = Jwts.builder().claims((Map)claims).signWith((Key)Keys.hmacShaKeyFor((byte[])keyBytes), this.settings.getSignatureAlg());
        String token = builder.compact();
        return new JsonWebAccessToken(token, claims);
    }

    protected Object mapDetails(Authentication auth) {
        return auth.getDetails();
    }

    @Override
    public Mono<AccessToken> validateRefreshTokenAsync(String token) {
        return Mono.just((Object)this.parseToken(token)).cast(AccessToken.class).filter(accessToken -> accessToken.getRoles().contains(this.settings.getRefreshTokenRole())).switchIfEmpty(Mono.error((Throwable)new InsufficientAuthenticationException(this.settings.getRefreshTokenRole()))).filterWhen(tok -> {
            log.debug("validateRefreshTokenAsync: subject = " + tok.getSubject());
            return this.revocationHandler != null ? this.revocationHandler.isRevoked((AccessToken)tok).map(r -> r == false) : Mono.just((Object)true);
        }).switchIfEmpty(Mono.error((Throwable)new AccountExpiredException("Refresh token revoked"))).doOnSuccess(tok -> log.info("validateRefreshTokenAsync: tok : " + tok)).doOnError(throwable -> log.info("validateRefreshTokenAsync: error : " + throwable));
    }

    public Mono<AccessToken> validateRefresh(String token) {
        AccessToken accessToken = super.parseToken(token);
        List scopes = accessToken.getRoles();
        if (scopes == null || !scopes.contains(this.settings.getRefreshTokenRole())) {
            throw new InsufficientAuthenticationException(this.settings.getRefreshTokenRole());
        }
        if (this.revocationHandler != null) {
            return this.revocationHandler.isRevoked(accessToken).flatMap(revoked -> revoked != false ? Mono.error((Throwable)new AccountExpiredException("Refresh token revoked")) : Mono.just((Object)false)).map(r -> accessToken);
        }
        return Mono.just((Object)accessToken);
    }

    public Mono<AccessToken> revokeRefresh(String token) {
        AccessToken accessToken = super.parseToken(token);
        if (this.revocationHandler != null) {
            return this.revocationHandler.revoke(accessToken).thenReturn((Object)accessToken);
        }
        return Mono.just((Object)accessToken);
    }

    public Mono<Void> revokeAllBefore(Instant cutOff) {
        if (this.revocationHandler != null) {
            return this.revocationHandler.revokeAllBefore(cutOff);
        }
        return Mono.empty();
    }

    public JsonWebAccessToken createAccessToken(Authentication auth) {
        return this.createAccessToken(auth, null);
    }

    public JsonWebAccessToken createAccessToken(Authentication auth, Date expiry) {
        LocalDateTime currentTime = LocalDateTime.now();
        Date expiration = expiry != null ? expiry : Date.from(currentTime.plusMinutes(this.settings.getTokenExpirationMinutes().intValue()).atZone(ZoneId.systemDefault()).toInstant());
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)((ClaimsBuilder)((ClaimsBuilder)Jwts.claims().subject(auth.getName())).issuedAt(Date.from(currentTime.atZone(ZoneId.systemDefault()).toInstant()))).expiration(expiration);
        if (this.settings.getTokenIssuer() != null) {
            claimsBuilder.issuer(this.settings.getTokenIssuer());
        }
        claimsBuilder.add((Object)"scope", this.convertAuthorities(auth));
        if (auth.getDetails() != null) {
            claimsBuilder.add((Object)"details", this.mapDetails(auth));
        }
        byte[] keyBytes = this.settings.getSigningKey().getBytes();
        Claims claims = (Claims)claimsBuilder.build();
        JwtBuilder builder = Jwts.builder().claims((Map)claims).signWith((Key)Keys.hmacShaKeyFor((byte[])keyBytes), this.settings.getSignatureAlg());
        String token = builder.compact();
        return new JsonWebAccessToken(token, claims);
    }

    public JsonWebAccessToken createSystemToken(String username, Object details, String ... roles) {
        LocalDateTime currentTime = LocalDateTime.now();
        ClaimsBuilder claimsBuilder = (ClaimsBuilder)((ClaimsBuilder)Jwts.claims().subject(username)).issuedAt(Date.from(currentTime.atZone(ZoneId.systemDefault()).toInstant()));
        if (this.settings.getTokenIssuer() != null) {
            claimsBuilder.issuer(this.settings.getTokenIssuer());
        }
        claimsBuilder.add((Object)"scope", Arrays.asList(roles));
        if (details != null) {
            claimsBuilder.add((Object)"details", details);
        }
        byte[] keyBytes = this.settings.getSigningKey().getBytes();
        Claims claims = (Claims)claimsBuilder.build();
        JwtBuilder builder = Jwts.builder().claims((Map)claims).signWith((Key)Keys.hmacShaKeyFor((byte[])keyBytes), this.settings.getSignatureAlg());
        String token = builder.compact();
        return new JsonWebAccessToken(token, claims);
    }

    protected List<String> convertAuthorities(Authentication authentication) {
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{settings=" + this.settings + ", revocationHandler=" + this.revocationHandler + "} " + super.toString();
    }
}

