/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.token.json;

import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.jwt.token.JwsTokenReader;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAccessToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import javax.crypto.SecretKey;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import reactor.core.publisher.Mono;

public class JsonWebTokenReader
implements JwsTokenReader {
    private final SecretKey secretKey;
    protected int clockSkewSeconds = 30;

    public JsonWebTokenReader(String signingKey) {
        this.secretKey = Keys.hmacShaKeyFor((byte[])signingKey.getBytes());
    }

    private Jws<Claims> parseClaims(String token) {
        try {
            return Jwts.parser().verifyWith(this.secretKey).clockSkewSeconds((long)this.clockSkewSeconds).build().parseSignedClaims((CharSequence)token);
        }
        catch (MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException ex) {
            throw new BadCredentialsException("TOKEN_INVALID", ex);
        }
        catch (ExpiredJwtException expiredEx) {
            throw new CredentialsExpiredException("TOKEN_EXPIRED", (Throwable)expiredEx);
        }
    }

    public Mono<AccessToken> parseTokenAsync(String input) {
        return Mono.fromSupplier(() -> this.parseToken(input));
    }

    public AccessToken parseToken(String input) {
        try {
            return new JsonWebAccessToken(input, (Claims)this.parseClaims(input).getPayload());
        }
        catch (MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException ex) {
            throw new BadCredentialsException("TOKEN_INVALID", ex);
        }
        catch (ExpiredJwtException expiredEx) {
            throw new CredentialsExpiredException("TOKEN_EXPIRED", (Throwable)expiredEx);
        }
    }
}

