/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.token.json;

import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import inc.yukawa.chain.security.service.TokenReader;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationProvider.class);
    private final TokenReader tokenReader;

    @Autowired
    public JwtAuthenticationProvider(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        log.trace("authenticate: authenticating {}", (Object)authentication);
        Object credentials = authentication.getCredentials();
        AccessToken access = this.tokenReader.parseToken(String.valueOf(credentials));
        List authorities = access.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        log.debug("authenticate: {}", (Object)access);
        return new JsonWebAuthenticationToken(access.getSubject(), access.getToken(), access.getDetails(), authorities);
    }

    public boolean supports(Class<?> authentication) {
        return JsonWebAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

