/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.token.json;

import inc.yukawa.chain.security.jwt.token.json.JsonWebAuthenticationToken;
import inc.yukawa.chain.security.service.TokenExtractor;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JwtTokenAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private final AuthenticationFailureHandler failureHandler;
    private final TokenExtractor tokenExtractor;
    private boolean clearContext = true;

    @Autowired
    public JwtTokenAuthenticationProcessingFilter(AuthenticationFailureHandler failureHandler, TokenExtractor tokenExtractor, RequestMatcher matcher) {
        super(matcher);
        this.failureHandler = failureHandler;
        this.tokenExtractor = tokenExtractor;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String tokenPayload = this.tokenExtractor.extract(request.getHeader("Authorization"));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("attemptAuthentication with tokenPayload " + tokenPayload));
        }
        return this.getAuthenticationManager().authenticate((Authentication)new JsonWebAuthenticationToken(tokenPayload));
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("successfulAuthentication: " + request.getMethod() + " " + request.getRequestURI() + " -> " + authResult.getName() + " " + authResult.getAuthorities() + " " + authResult.getDetails()));
        }
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(authResult);
        SecurityContextHolder.setContext((SecurityContext)context);
        request.setAttribute("auth", (Object)authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (this.clearContext) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("successfulAuthentication: clear context " + authResult.getName()));
            }
            SecurityContextHolder.clearContext();
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("unsuccessfulAuthentication " + request.getMethod() + " " + request.getServletPath()));
        }
        SecurityContextHolder.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response, failed);
    }

    public boolean isClearContext() {
        return this.clearContext;
    }

    public void setClearContext(boolean clearContext) {
        this.clearContext = clearContext;
    }
}

