/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.core.domain.change.Change;
import inc.yukawa.chain.base.core.domain.change.Changed;
import inc.yukawa.chain.base.core.domain.change.Created;
import inc.yukawa.chain.base.core.domain.entity.EntityFilter;
import inc.yukawa.chain.base.core.domain.organization.Organized;
import inc.yukawa.chain.security.domain.GroupContext;
import inc.yukawa.chain.security.jwt.util.ChainSpringPrincipal;
import inc.yukawa.chain.security.principal.AuthContext;
import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AuthContextHelper
implements AuthContext<Authentication, GrantedAuthority> {
    public static final Consumer<String> NOOP = t -> {};
    protected String groupsKey;
    protected String organisationIdsKey;
    protected String groupContextsKey;

    public AuthContextHelper() {
        this("groupContexts", "organisationIds", "groupContexts");
    }

    public AuthContextHelper(String groupsKey, String organisationIdsKey) {
        this.groupsKey = groupsKey;
        this.organisationIdsKey = organisationIdsKey;
    }

    public AuthContextHelper(String groupsKey, String organisationIdsKey, String groupContextsKey) {
        this.groupsKey = groupsKey;
        this.organisationIdsKey = organisationIdsKey;
        this.groupContextsKey = groupContextsKey;
    }

    public Mono<Authentication> auth() {
        return ReactiveSecurityContextHolder.getContext().map(SecurityContext::getAuthentication);
    }

    public Mono<String> authPrincipal() {
        return this.auth().map(a -> (String)a.getPrincipal());
    }

    public Mono<String> authUserId() {
        return this.auth().flatMap(a -> Mono.justOrEmpty((Object)this.authUserIdFrom((Authentication)a)));
    }

    public Mono<Map<String, Object>> authDetails() {
        return this.auth().map(this::authDetailsFrom);
    }

    public Mono<Set<String>> authUserGroups() {
        return this.auth().map(this::authUserGroupsFrom);
    }

    public Mono<String> authOrganisationId() {
        return this.auth().flatMap(a -> Mono.justOrEmpty((Object)this.authOrganisationIdFrom((Authentication)a)));
    }

    public Map<String, Object> authDetailsFrom(Authentication auth) {
        return auth.getDetails() != null ? (Map)auth.getDetails() : new HashMap();
    }

    public Set<String> authUserGroupsFrom(Authentication auth) {
        GroupContext contextForOrg = this.groupContextForOrg(auth);
        Set<String> groups = contextForOrg != null ? contextForOrg.getGroups() : Collections.emptySet();
        return groups != null ? groups : Collections.emptySet();
    }

    public List<GroupContext> groupContextsFrom(Authentication auth) {
        ObjectMapper mapper = new ObjectMapper();
        return (List)mapper.convertValue(this.authDetailsFrom(auth).get(this.groupContextsKey), (TypeReference)new TypeReference<List<GroupContext>>(){});
    }

    public GroupContext groupContextForOrg(Authentication auth) {
        return this.groupContextsFrom(auth).stream().filter(ctx -> ctx.getOrgId().equals(this.authOrganisationIdFrom(auth))).findFirst().orElse(null);
    }

    public List<String> authOrganisationIdsFrom(Authentication auth) {
        List organizationIds = (List)this.authDetailsFrom(auth).get(this.organisationIdsKey);
        return organizationIds != null ? new ArrayList(organizationIds) : null;
    }

    public Flux<String> fluxOrganisationIdsFrom(Authentication auth) {
        List organizationIds = (List)this.authDetailsFrom(auth).get(this.organisationIdsKey);
        return organizationIds != null ? Flux.fromIterable((Iterable)organizationIds) : Flux.empty();
    }

    public String authUserIdFrom(Authentication auth) {
        return (String)this.authDetailsFrom(auth).get("userId");
    }

    public String authOrganisationIdFrom(Authentication auth) {
        return (String)this.authDetailsFrom(auth).get("orgId");
    }

    public <T> Mono<T> callerScopeFor(T obj, Supplier<String> orgIdSupplier, Consumer<String> orgIdSetter) {
        return this.auth().flatMap(a -> {
            String orgId = (String)orgIdSupplier.get();
            String callerOrgId = this.authOrganisationIdFrom((Authentication)a);
            if (a.getAuthorities().stream().anyMatch(this::isAdmin)) {
                if (orgId == null && callerOrgId != null) {
                    orgIdSetter.accept(callerOrgId);
                }
                return Mono.just((Object)obj);
            }
            if (callerOrgId == null || orgId != null && !callerOrgId.equals(orgId)) {
                return Mono.error((Throwable)new AccessDeniedException("orgId='" + orgId + "' not in caller scope"));
            }
            orgIdSetter.accept(callerOrgId);
            return Mono.just((Object)obj);
        });
    }

    public <T> Mono<T> callerScopeFor(T obj, Function<T, String> orgIdExtractor, Consumer<String> orgIdSetter) {
        return this.callerScopeFor(obj, () -> (String)orgIdExtractor.apply(obj), orgIdSetter);
    }

    public <O extends Organized> Mono<O> callerScopeFor(O obj) {
        return this.callerScopeFor(obj, () -> obj.getOrgId(), arg_0 -> obj.setOrgId(arg_0));
    }

    public <F extends EntityFilter> Mono<F> callerScopeForFilter(F filter) {
        return this.callerScopeFor(filter, () -> filter.getOrgId(), arg_0 -> filter.setOrgId(arg_0));
    }

    public <T extends Changed> Mono<T> withChanged(T obj) {
        return this.authPrincipal().map(p -> {
            obj.setChange(new Change(p, new Date()));
            return obj;
        });
    }

    public <T extends Created> Mono<T> withCreated(T obj) {
        return this.authPrincipal().map(p -> {
            obj.setCreated(new Change(p, new Date()));
            return obj;
        });
    }

    public <T extends Changed & Created> Mono<T> withChangedAndCreated(T obj) {
        return this.authPrincipal().map(p -> {
            obj.setChange(new Change(p, new Date()));
            ((Created)obj).setCreated(obj.getChange());
            return obj;
        });
    }

    public Mono<Boolean> hasRole(String role) {
        return this.auth().map(a -> a.getAuthorities() != null && a.getAuthorities().stream().anyMatch(r -> r.getAuthority().equals(role))).switchIfEmpty(Mono.just((Object)Boolean.FALSE));
    }

    public Mono<Boolean> isAdmin() {
        return this.hasRole("ROLE_ADMIN");
    }

    public boolean isAdmin(GrantedAuthority authority) {
        return "ROLE_ADMIN".equalsIgnoreCase(authority.getAuthority());
    }

    public Mono<ChainPrincipal> chainPrincipal() {
        Mono<Authentication> auth = this.auth();
        return auth.map(ChainSpringPrincipal::new);
    }
}

