/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.util;

import inc.yukawa.chain.security.principal.ChainPrincipal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ChainSpringPrincipal
implements ChainPrincipal {
    private final Authentication authentication;

    public ChainSpringPrincipal(Authentication authentication) {
        this.authentication = authentication;
    }

    protected Authentication getAuthentication() {
        if (this.authentication == null) {
            throw new NullPointerException(this.getClass().getSimpleName() + ".authentication");
        }
        return this.authentication;
    }

    public String getUserId() {
        return this.getName();
    }

    public boolean inGroup(String s) {
        throw new UnsupportedOperationException(".inGroup not implemented");
    }

    public boolean inOrg(String l) {
        return l.equals(this.getOrgId());
    }

    public String getOrgId() {
        return (String)this.getDetails().get("orgId");
    }

    public List<String> getOrgIds() {
        return (List)this.getDetail("organisationIds");
    }

    public Object getDetail(String key) {
        return this.getDetails().get(key);
    }

    private Map<String, Object> getDetails() {
        return (Map)this.getAuthentication().getDetails();
    }

    public boolean inLocale(String s) {
        return false;
    }

    public String getName() {
        try {
            return this.getAuthentication().getName();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String getLang() {
        return "de";
    }

    public boolean inRole(String s) {
        return this.getAuthentication().getAuthorities().contains(new SimpleGrantedAuthority(s));
    }

    public List<String> getRoles() {
        return this.getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }

    public String toString() {
        try {
            Authentication auth = this.getAuthentication();
            return "ChainSpringPrincipal{" + this.getUserId() + ", " + auth.getAuthorities() + "}";
        }
        catch (Exception e) {
            return "ChainSpringPrincipal{?" + e.getMessage() + "?}";
        }
    }
}

