/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AjaxAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AjaxAuthenticationProvider.class);
    private final PasswordEncoder encoder;
    private final UserDetailsService userService;

    @Autowired
    public AjaxAuthenticationProvider(UserDetailsService userService, PasswordEncoder encoder) {
        this.userService = userService;
        this.encoder = encoder;
        log.debug("init userService = {}", (Object)userService);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        log.trace("Authenticate: {}", (Object)authentication);
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        UserDetails user = this.userService.loadUserByUsername(username);
        if (user == null) {
            log.trace("authenticate: access denied for {} - user not found", (Object)username);
            throw new BadCredentialsException("Authentication Failed. Username or Password not valid.");
        }
        if (!this.encoder.matches((CharSequence)password, user.getPassword())) {
            log.trace("authenticate: access denied for {} - incorrect password", (Object)username);
            throw new BadCredentialsException("Authentication Failed. Username or Password not valid.");
        }
        if (user.getAuthorities() == null) {
            log.trace("authenticate: access denied for {} - no roles", (Object)username);
            throw new InsufficientAuthenticationException("User has no roles assigned");
        }
        return new UsernamePasswordAuthenticationToken((Object)user.getUsername(), null, user.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

