/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.jwt.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.service.TokenFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class AjaxAwareAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(AjaxAwareAuthenticationSuccessHandler.class);
    private final ObjectMapper mapper;
    private final TokenFactory<Authentication, AccessToken> tokenFactory;

    @Autowired
    public AjaxAwareAuthenticationSuccessHandler(ObjectMapper mapper, TokenFactory<Authentication, AccessToken> tokenFactory) {
        this.mapper = mapper;
        this.tokenFactory = tokenFactory;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        log.trace("onAuthenticationSuccess: {}", (Object)authentication);
        AccessToken accessToken = (AccessToken)this.tokenFactory.createAccessToken((Object)authentication);
        AccessToken refreshToken = (AccessToken)this.tokenFactory.createRefreshToken((Object)authentication);
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put("accessToken", accessToken.getToken());
        tokenMap.put("accessExpiration", accessToken.getExpiration());
        tokenMap.put("accessRoles", accessToken.getRoles());
        tokenMap.put("refreshToken", refreshToken.getToken());
        tokenMap.put("refreshExpiration", refreshToken.getExpiration());
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        this.mapper.writeValue((Writer)response.getWriter(), tokenMap);
        this.clearAuthenticationAttributes(request);
    }

    protected final void clearAuthenticationAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("SPRING_SECURITY_LAST_EXCEPTION");
    }
}

