/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.kafka.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaAsyncWriteDao;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.kafka.dao.AccountLoadDao2;
import inc.yukawa.chain.security.kafka.dao.AccountRepository2;
import inc.yukawa.chain.security.kafka.dao.RevocationLoadDao;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;

@Configuration
public class DaoConfig {
    @Bean(value={"security.RevocationLoadDao"})
    public MonoLoadDao<String, String> revocationLoadDao(@Qualifier(value="security.RevocationStreamsProps") Properties props) {
        return new RevocationLoadDao(props);
    }

    @Bean(value={"security.RevocationWriteDao"})
    public MonoWriteDao<String, String> revocationWriteDao(@Qualifier(value="security.RevokedTokensProducer") ReactiveKafkaProducerTemplate<String, String> template, @Qualifier(value="auth.RevocationTopic") NewTopic topic) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Primary
    @Bean(value={"security.AccountWriteDao"})
    public MonoWriteDao<String, Account> accountWriteDao(@Qualifier(value="security.AccountTemplate") ReactiveKafkaProducerTemplate<String, Account> template, @Qualifier(value="security.AccountTopic") NewTopic topic) {
        return new KafkaAsyncWriteDao(template, topic);
    }

    @Primary
    @Bean(value={"security.AccountLoadDao"})
    public AccountLoadDao2 accountLoadDao(@Qualifier(value="security.StreamsProps") Properties props, ObjectMapper mapper) {
        return new AccountLoadDao2(props, mapper);
    }

    @Bean(value={"security.AccountRepository"})
    public AccountRepository2 accountRepository(AccountLoadDao2 accountLoadDao, @Qualifier(value="security.AccountWriteDao") MonoWriteDao<String, Account> writeDao) {
        return new AccountRepository2(accountLoadDao, accountLoadDao, writeDao);
    }
}

