/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.kafka.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import inc.yukawa.chain.base.core.event.ChainEvent;
import inc.yukawa.chain.base.core.event.EventProducer;
import inc.yukawa.chain.kafka.config.KafkaStreamsConfigBase;
import inc.yukawa.chain.kafka.event.KafkaEventProducer;
import inc.yukawa.chain.kafka.util.StreamUtil;
import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.domain.Account;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.core.reactive.ReactiveKafkaProducerTemplate;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
public class KafkaConfig
extends KafkaStreamsConfigBase {
    @Value(value="${server.port}")
    private final int port = 3080;
    @Value(value="${server.host:auto}")
    private final String host = "auto";

    public ObjectMapper objectMapper() {
        ObjectMapper mapper = super.objectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    @Bean
    public ProducerFactory<String, Object> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfig(), Serdes.String().serializer(), (Serializer)new JsonSerializer(this.objectMapper()));
    }

    @Bean(value={"security.AccessEventTemplate"})
    @Profile(value={"beta"})
    protected KafkaTemplate<String, ChainEvent<AccessToken>> accessEventTemplate(@Qualifier(value="security.AccessEventTopic") NewTopic topic, ObjectMapper mapper) {
        return this.kafkaTemplate(Serdes.String().serializer(), (Serializer)new JsonSerializer(mapper), topic.name());
    }

    @Bean(value={"security.AccessEventProducer"})
    @Profile(value={"beta"})
    public EventProducer<String, AccessToken> accessEventProducer(@Qualifier(value="security.AccessEventTemplate") KafkaTemplate<String, ChainEvent<AccessToken>> template) {
        return new KafkaEventProducer(template);
    }

    @Bean(value={"security.AccountTemplate"})
    public ReactiveKafkaProducerTemplate<String, Account> accountTemplate(KafkaProperties properties, ObjectMapper mapper) {
        return this.reactiveKafkaTemplate(properties, Serdes.String().serializer(), (Serializer)new JsonSerializer(mapper));
    }

    @Bean(value={"security.RevokedTokensProducer"})
    public ReactiveKafkaProducerTemplate<String, String> revokedTokensProducer(KafkaProperties properties) {
        return this.reactiveKafkaTemplate(properties, Serdes.String().serializer(), Serdes.String().serializer());
    }

    @Bean(value={"security.StreamsProps"})
    public Properties streamsProps() {
        Properties props = this.baseStreamsProps();
        props.put("application.server", StreamUtil.initHostAddress((String)"auto") + ":3080");
        return props;
    }

    @Bean(value={"security.RevocationStreamsProps"})
    public Properties revocationStreamsProps() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.streamsProps());
        props.put("application.id", this.appId + "-Revocation");
        return props;
    }
}

