/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.kafka.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.kafka.dao.mono.KafkaStreamsDao;
import inc.yukawa.chain.kafka.util.KafkaUtil;
import inc.yukawa.chain.kafka.util.StreamUtil;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.Stores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.support.serializer.JsonSerde;
import reactor.core.publisher.Mono;

@Deprecated
public class AccountLoadDao
extends KafkaStreamsDao
implements MonoLoadDao<String, Account> {
    private static final Logger log = LoggerFactory.getLogger(AccountLoadDao.class);
    private final ObjectMapper mapper;
    @Value(value="${chain.security.account.topic}")
    private String accountTopic;
    @Value(value="${chain.security.credentials.topic}")
    private String credentialsTopic;
    @Value(value="${chain.security.roles.topic}")
    private String rolesTopic;
    @Value(value="${chain.security.account.store:accounts}")
    private String accountsStoreName;
    @Value(value="${chain.security.credentials.store:credentials}")
    private String credentialsStoreName;
    @Value(value="${chain.security.roles.store:roles}")
    private String rolesStoreName;

    public AccountLoadDao(Properties streamProps, ObjectMapper mapper) {
        super(streamProps);
        this.mapper = mapper;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AccountLoadDao{");
        sb.append("accountTopic='").append(this.accountTopic).append('\'');
        sb.append(", credentialsTopic='").append(this.credentialsTopic).append('\'');
        sb.append(", rolesTopic='").append(this.rolesTopic).append('\'');
        sb.append('}');
        return sb.toString();
    }

    protected StreamsBuilder buildStreams() {
        StreamsBuilder builder = new StreamsBuilder();
        Serde keySerDes = Serdes.String();
        Serde accountSer = KafkaUtil.getSerDes(Account.class, (boolean)false, (ObjectMapper)this.mapper);
        HashMap<String, String> cfg = new HashMap<String, String>();
        cfg.put("spring.json.type.mapping", "inc.accentro.integration.auth.core.domain.Credentials:inc.yukawa.chain.security.domain.Credentials,inc.accentro.integration.auth.core.domain.Account:inc.yukawa.chain.security.domain.Account");
        accountSer.configure(cfg, false);
        Serde passSer = KafkaUtil.getSerDes(Credentials.class, (boolean)false, (ObjectMapper)this.mapper);
        passSer.configure(cfg, false);
        JsonSerde rolesSer = new JsonSerde(Set.class);
        Materialized accountStore = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)this.accountsStoreName)).withKeySerde(keySerDes).withValueSerde(accountSer);
        Materialized credentialsStore = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)this.credentialsStoreName)).withKeySerde(keySerDes).withValueSerde(passSer);
        Materialized rolesStore = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)this.rolesStoreName)).withKeySerde(keySerDes).withValueSerde((Serde)rolesSer);
        GlobalKTable accountsTable = builder.globalTable(this.accountTopic, Consumed.with((Serde)keySerDes, (Serde)accountSer), accountStore);
        GlobalKTable credentialsTable = builder.globalTable(this.credentialsTopic, Consumed.with((Serde)keySerDes, (Serde)passSer), credentialsStore);
        GlobalKTable rolesTable = builder.globalTable(this.rolesTopic, Consumed.with((Serde)keySerDes, (Serde)rolesSer), rolesStore);
        return builder;
    }

    private Credentials readValue(String value) {
        try {
            return (Credentials)this.mapper.readValue(value, Credentials.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Mono<Account> load(String key) {
        return this.loadAccount(key).zipWith(this.loadCredentials(key).defaultIfEmpty((Object)new Credentials()), (acc, cre) -> {
            acc.setCredentials(cre);
            return acc;
        }).zipWith(this.loadRoles(key).defaultIfEmpty(Collections.emptySet()), (acc, roles) -> {
            acc.setRoles(roles);
            return acc;
        });
    }

    public Mono<Account> loadAccount(String key) {
        log.debug("Load: {} from {} of {}", new Object[]{key, this.accountsStoreName, this.accountTopic});
        return Mono.fromSupplier(this::waitForAccountsStore).filter(s -> s.get((Object)key) != null).map(s -> (Account)s.get((Object)key));
    }

    public Mono<Credentials> loadCredentials(String key) {
        log.debug("Load: {} from {} of {}", new Object[]{key, this.credentialsStoreName, this.credentialsTopic});
        return Mono.fromSupplier(this::waitForCredentialsStore).filter(s -> s.get((Object)key) != null).map(s -> (Credentials)s.get((Object)key));
    }

    public Mono<Set<String>> loadRoles(String key) {
        log.debug("Load: {} from {} of {}", new Object[]{key, this.rolesStoreName, this.rolesTopic});
        return Mono.fromSupplier(this::waitForRolesStore).filter(s -> s.get((Object)key) != null).map(s -> (Set)s.get((Object)key));
    }

    protected ReadOnlyKeyValueStore<String, Account> waitForAccountsStore() {
        QueryableStoreType st = QueryableStoreTypes.keyValueStore();
        return (ReadOnlyKeyValueStore)StreamUtil.waitUntilStoreIsQueryable((String)this.accountsStoreName, (QueryableStoreType)st, (KafkaStreams)this.streams, (long)this.timeout);
    }

    protected ReadOnlyKeyValueStore<String, Credentials> waitForCredentialsStore() {
        QueryableStoreType st = QueryableStoreTypes.keyValueStore();
        return (ReadOnlyKeyValueStore)StreamUtil.waitUntilStoreIsQueryable((String)this.credentialsStoreName, (QueryableStoreType)st, (KafkaStreams)this.streams, (long)this.timeout);
    }

    protected ReadOnlyKeyValueStore<String, Set<String>> waitForRolesStore() {
        QueryableStoreType st = QueryableStoreTypes.keyValueStore();
        return (ReadOnlyKeyValueStore)StreamUtil.waitUntilStoreIsQueryable((String)this.rolesStoreName, (QueryableStoreType)st, (KafkaStreams)this.streams, (long)this.timeout);
    }
}

