/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.kafka.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import inc.yukawa.chain.kafka.dao.mono.KafkaStreamsDao;
import inc.yukawa.chain.kafka.util.KafkaUtil;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.domain.Credentials;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneTimePasswordSupportStream
extends KafkaStreamsDao {
    private static final Logger log = LoggerFactory.getLogger(OneTimePasswordSupportStream.class);
    private final Random random = new Random();
    private final String authEventTopic;
    private final String accountTopic;
    private final Serde<Account> accountSerde;
    private final BiPredicate<String, Account> filter;
    protected final Function<String, String> passwordEncodeFunction;
    private int randomPassSize = 32;

    public OneTimePasswordSupportStream(Properties streamProps, NewTopic authEventTopic, NewTopic accountTopic, Function<String, String> passwordEncodeFunction, BiPredicate<String, Account> filter, ObjectMapper mapper) {
        super(streamProps);
        this.authEventTopic = authEventTopic.name();
        this.accountTopic = accountTopic.name();
        this.accountSerde = KafkaUtil.getSerDes(Account.class, (boolean)false, (ObjectMapper)mapper);
        this.filter = filter;
        this.passwordEncodeFunction = passwordEncodeFunction;
    }

    protected StreamsBuilder buildStreams() {
        StreamsBuilder builder = new StreamsBuilder();
        Materialized accountStore = Materialized.as((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"accounts")).withKeySerde(Serdes.String()).withValueSerde(this.accountSerde);
        KTable accountKTable = builder.table(this.accountTopic, accountStore);
        builder.stream(this.authEventTopic, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String())).filter((k, evt) -> k != null && evt != null).peek((k, v) -> log.debug("[{}@{}] Received authEvent", k, (Object)this.authEventTopic)).filter((k, evt) -> evt.contains("auth:authenticated")).join(accountKTable, (e, a) -> a, Joined.with((Serde)Serdes.String(), (Serde)Serdes.String(), this.accountSerde)).filter(this::inInvalidateScope).peek((k, v) -> log.info("[{}@{}] Invalidating pass for user: {}", new Object[]{k, this.authEventTopic, k})).mapValues(this::asResetPassAccount).peek((k, v) -> log.debug("[{}@{}] PUT account: {}", new Object[]{k, this.accountTopic, v})).to(this.accountTopic, Produced.with((Serde)Serdes.String(), this.accountSerde));
        return builder;
    }

    private Account asResetPassAccount(String username, Account account) {
        String orgId = account.getCredentials() != null ? account.getCredentials().getOrgId() : null;
        String pass = this.randomAlphanumericString(this.randomPassSize);
        String encodedPass = this.passwordEncodeFunction.apply(pass);
        Credentials credentials = new Credentials(username, encodedPass, orgId);
        return new Account(credentials, null);
    }

    private boolean inInvalidateScope(String username, Account account) {
        boolean inScope = this.filter.test(username, account);
        if (!inScope) {
            log.debug("Skipping not in scope account: {} {}", (Object)username, (Object)account);
        }
        return inScope;
    }

    public String randomAlphanumericString(int len) {
        int leftLimit = 48;
        int rightLimit = 122;
        return this.random.ints(leftLimit, rightLimit + 1).limit(len).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public int getRandomPassSize() {
        return this.randomPassSize;
    }

    public void setRandomPassSize(int randomPassSize) {
        this.randomPassSize = randomPassSize;
    }

    public static BiPredicate<String, Account> notExcludedAndHeavingOneTimePassword(List<String> excludedUsers, String oneTimePasswordDetailsKey) {
        Predicate<String> excludedByList = excludedUsers != null ? excludedUsers::contains : s -> false;
        Predicate<Account> hasOneTimePassword = acc -> Optional.ofNullable(acc).map(Account::getDetails).map(m -> m.get(oneTimePasswordDetailsKey)).filter(Boolean.TRUE::equals).isPresent();
        Predicate<String> notExcluded = excludedByList.negate();
        return (username, evt) -> notExcluded.test((String)username) && hasOneTimePassword.test((Account)evt);
    }
}

