/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.service;

import inc.yukawa.chain.base.core.domain.result.EditResult;
import inc.yukawa.chain.base.core.domain.result.QueryResult;
import inc.yukawa.chain.base.mono.repos.MonoRepository;
import inc.yukawa.chain.security.domain.Account;
import inc.yukawa.chain.security.filter.AccountFilter;
import inc.yukawa.chain.security.service.AccountAspect;
import org.springframework.security.crypto.password.PasswordEncoder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AccountService
implements AccountAspect {
    private final MonoRepository<String, Account, AccountFilter> repository;
    private final PasswordEncoder passwordEncoder;

    public AccountService(MonoRepository<String, Account, AccountFilter> repository, PasswordEncoder passwordEncoder) {
        this.repository = repository;
        this.passwordEncoder = passwordEncoder;
    }

    public Mono<Account> loadAccount(String username) {
        return this.repository.load((Object)username);
    }

    public Mono<EditResult> editAccount(Account account) {
        if (account.getCredentials() != null && account.getCredentials().getPassword() != null) {
            account.getCredentials().setPassword(this.passwordEncoder.encode((CharSequence)account.getCredentials().getPassword()));
        }
        return this.repository.edit((Object)account);
    }

    public Flux<Account> findAccounts(AccountFilter filter) {
        return this.repository.find((Object)filter);
    }

    public Mono<QueryResult<Account>> queryAccounts(AccountFilter filter) {
        return this.repository.query((Object)filter);
    }

    public Mono<EditResult> deleteAccount(String username) {
        return this.repository.removeKey((Object)username);
    }
}

