/*
 * Decompiled with CFR 0.152.
 */
package inc.yukawa.chain.security.service;

import inc.yukawa.chain.base.mono.dao.MonoLoadDao;
import inc.yukawa.chain.base.mono.dao.MonoWriteDao;
import inc.yukawa.chain.security.domain.AccessToken;
import inc.yukawa.chain.security.service.RevocationAspect;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class BaseRevocationService
implements RevocationAspect {
    private static final Logger log = LoggerFactory.getLogger(BaseRevocationService.class);
    protected final MonoWriteDao<String, String> writeDao;
    protected final MonoLoadDao<String, String> readDao;

    public BaseRevocationService(MonoWriteDao<String, String> writeDao, MonoLoadDao<String, String> readDao) {
        this.writeDao = writeDao;
        this.readDao = readDao;
    }

    public Mono<Boolean> revoke(AccessToken token) {
        log.debug("Revoking token: {}", (Object)token.getId());
        Assert.hasText((String)token.getId(), (String)"blank id");
        return this.writeDao.put((Object)token.getId(), (Object)token.getId()).thenReturn((Object)true);
    }

    public Mono<Boolean> isRevoked(AccessToken token) {
        return this.readDao.load((Object)token.getId()).zipWhen(t -> this.beforeCutOffTime(token.getIssuedAt()), (t, revoked) -> revoked).defaultIfEmpty((Object)false);
    }

    public Mono<Void> revokeAllBefore(Instant cutOff) {
        Assert.state((boolean)cutOff.isBefore(Instant.now()), (String)"cutOff in future");
        return this.writeDao.put((Object)"security-revoke-all-tokens", (Object)DateTimeFormatter.ISO_INSTANT.format(cutOff)).then();
    }

    public Mono<Void> revokeAllBefore(String username, Instant cutOff) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Mono<Void> cleanup() {
        return Mono.empty();
    }

    private Mono<Boolean> beforeCutOffTime(Date issuedAt) {
        return this.readDao.load((Object)"security-revoke-all-tokens").map(Instant::parse).filter(i -> i.isBefore(Instant.now())).map(i -> issuedAt != null && i.isAfter(issuedAt.toInstant())).defaultIfEmpty((Object)false);
    }
}

